# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Session(object):
    """
    A session represents an interactive conversation initiated by a user through an API to engage with an agent. It involves a series of exchanges where the user sends queries or prompts, and the agent responds with relevant information, actions, or assistance based on the user's input. The session persists for the duration of the interaction, maintaining context and continuity to provide coherent and meaningful responses throughout the conversation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Session object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Session.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Session.
        :type display_name: str

        :param description:
            The value to assign to the description property of this Session.
        :type description: str

        :param welcome_message:
            The value to assign to the welcome_message property of this Session.
        :type welcome_message: str

        :param time_created:
            The value to assign to the time_created property of this Session.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Session.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'welcome_message': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'welcome_message': 'welcomeMessage',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._welcome_message = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Session.
        A unique ID for the session. This ID is immutable on creation.


        :return: The id of this Session.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Session.
        A unique ID for the session. This ID is immutable on creation.


        :param id: The id of this Session.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this Session.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this Session.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Session.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this Session.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Session.
        A description of the session.


        :return: The description of this Session.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Session.
        A description of the session.


        :param description: The description of this Session.
        :type: str
        """
        self._description = description

    @property
    def welcome_message(self):
        """
        Gets the welcome_message of this Session.
        A greeting message that the you receive when you start of a session.


        :return: The welcome_message of this Session.
        :rtype: str
        """
        return self._welcome_message

    @welcome_message.setter
    def welcome_message(self, welcome_message):
        """
        Sets the welcome_message of this Session.
        A greeting message that the you receive when you start of a session.


        :param welcome_message: The welcome_message of this Session.
        :type: str
        """
        self._welcome_message = welcome_message

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Session.
        The date and time that the session started in the format of an RFC3339 datetime string.


        :return: The time_created of this Session.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Session.
        The date and time that the session started in the format of an RFC3339 datetime string.


        :param time_created: The time_created of this Session.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Session.
        The date and time that the session was last updated in the format of an RFC3339 datetime string.


        :return: The time_updated of this Session.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Session.
        The date and time that the session was last updated in the format of an RFC3339 datetime string.


        :param time_updated: The time_updated of this Session.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
