# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_output import ToolOutput
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlToolOutput(ToolOutput):
    """
    Specifies the output format for SQL tools, including the generated SQL statement and an optional preview of the query result.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SqlToolOutput object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.SqlToolOutput.tool_output_type` attribute
        of this class is ``SQL_TOOL_OUTPUT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_id:
            The value to assign to the tool_id property of this SqlToolOutput.
        :type tool_id: str

        :param tool_name:
            The value to assign to the tool_name property of this SqlToolOutput.
        :type tool_name: str

        :param tool_output_type:
            The value to assign to the tool_output_type property of this SqlToolOutput.
            Allowed values for this property are: "GENERIC_TOOL_OUTPUT", "SQL_TOOL_OUTPUT", "RAG_TOOL_OUTPUT"
        :type tool_output_type: str

        :param generated_sql:
            The value to assign to the generated_sql property of this SqlToolOutput.
        :type generated_sql: str

        :param result:
            The value to assign to the result property of this SqlToolOutput.
        :type result: list[object]

        :param result_files:
            The value to assign to the result_files property of this SqlToolOutput.
        :type result_files: oci.generative_ai_agent_runtime.models.SqlResultFiles

        :param additional_info:
            The value to assign to the additional_info property of this SqlToolOutput.
        :type additional_info: str

        """
        self.swagger_types = {
            'tool_id': 'str',
            'tool_name': 'str',
            'tool_output_type': 'str',
            'generated_sql': 'str',
            'result': 'list[object]',
            'result_files': 'SqlResultFiles',
            'additional_info': 'str'
        }
        self.attribute_map = {
            'tool_id': 'toolId',
            'tool_name': 'toolName',
            'tool_output_type': 'toolOutputType',
            'generated_sql': 'generatedSql',
            'result': 'result',
            'result_files': 'resultFiles',
            'additional_info': 'additionalInfo'
        }
        self._tool_id = None
        self._tool_name = None
        self._tool_output_type = None
        self._generated_sql = None
        self._result = None
        self._result_files = None
        self._additional_info = None
        self._tool_output_type = 'SQL_TOOL_OUTPUT'

    @property
    def generated_sql(self):
        """
        **[Required]** Gets the generated_sql of this SqlToolOutput.
        Specifies the generated SQL query.


        :return: The generated_sql of this SqlToolOutput.
        :rtype: str
        """
        return self._generated_sql

    @generated_sql.setter
    def generated_sql(self, generated_sql):
        """
        Sets the generated_sql of this SqlToolOutput.
        Specifies the generated SQL query.


        :param generated_sql: The generated_sql of this SqlToolOutput.
        :type: str
        """
        self._generated_sql = generated_sql

    @property
    def result(self):
        """
        Gets the result of this SqlToolOutput.
        Represents preview rows from the SQL query.


        :return: The result of this SqlToolOutput.
        :rtype: list[object]
        """
        return self._result

    @result.setter
    def result(self, result):
        """
        Sets the result of this SqlToolOutput.
        Represents preview rows from the SQL query.


        :param result: The result of this SqlToolOutput.
        :type: list[object]
        """
        self._result = result

    @property
    def result_files(self):
        """
        Gets the result_files of this SqlToolOutput.

        :return: The result_files of this SqlToolOutput.
        :rtype: oci.generative_ai_agent_runtime.models.SqlResultFiles
        """
        return self._result_files

    @result_files.setter
    def result_files(self, result_files):
        """
        Sets the result_files of this SqlToolOutput.

        :param result_files: The result_files of this SqlToolOutput.
        :type: oci.generative_ai_agent_runtime.models.SqlResultFiles
        """
        self._result_files = result_files

    @property
    def additional_info(self):
        """
        Gets the additional_info of this SqlToolOutput.
        Specifies optional metadata content.


        :return: The additional_info of this SqlToolOutput.
        :rtype: str
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """
        Sets the additional_info of this SqlToolOutput.
        Specifies optional metadata content.


        :param additional_info: The additional_info of this SqlToolOutput.
        :type: str
        """
        self._additional_info = additional_info

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
