# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .cohere_message_v2 import CohereMessageV2
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereAssistantMessageV2(CohereMessageV2):
    """
    A message that represents a single chat dialog as CHATBOT role.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereAssistantMessageV2 object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereAssistantMessageV2.role` attribute
        of this class is ``ASSISTANT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param role:
            The value to assign to the role property of this CohereAssistantMessageV2.
            Allowed values for this property are: "ASSISTANT", "USER", "SYSTEM", "TOOL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type role: str

        :param content:
            The value to assign to the content property of this CohereAssistantMessageV2.
        :type content: list[oci.generative_ai_inference.models.CohereContentV2]

        :param tool_plan:
            The value to assign to the tool_plan property of this CohereAssistantMessageV2.
        :type tool_plan: str

        :param tool_calls:
            The value to assign to the tool_calls property of this CohereAssistantMessageV2.
        :type tool_calls: list[oci.generative_ai_inference.models.CohereToolCallV2]

        :param citations:
            The value to assign to the citations property of this CohereAssistantMessageV2.
        :type citations: list[oci.generative_ai_inference.models.CohereCitationV2]

        """
        self.swagger_types = {
            'role': 'str',
            'content': 'list[CohereContentV2]',
            'tool_plan': 'str',
            'tool_calls': 'list[CohereToolCallV2]',
            'citations': 'list[CohereCitationV2]'
        }
        self.attribute_map = {
            'role': 'role',
            'content': 'content',
            'tool_plan': 'toolPlan',
            'tool_calls': 'toolCalls',
            'citations': 'citations'
        }
        self._role = None
        self._content = None
        self._tool_plan = None
        self._tool_calls = None
        self._citations = None
        self._role = 'ASSISTANT'

    @property
    def tool_plan(self):
        """
        Gets the tool_plan of this CohereAssistantMessageV2.
        A chain-of-thought style reflection and plan that the model generates when working with Tools.


        :return: The tool_plan of this CohereAssistantMessageV2.
        :rtype: str
        """
        return self._tool_plan

    @tool_plan.setter
    def tool_plan(self, tool_plan):
        """
        Sets the tool_plan of this CohereAssistantMessageV2.
        A chain-of-thought style reflection and plan that the model generates when working with Tools.


        :param tool_plan: The tool_plan of this CohereAssistantMessageV2.
        :type: str
        """
        self._tool_plan = tool_plan

    @property
    def tool_calls(self):
        """
        Gets the tool_calls of this CohereAssistantMessageV2.
        A list of tool calls generated by the model.


        :return: The tool_calls of this CohereAssistantMessageV2.
        :rtype: list[oci.generative_ai_inference.models.CohereToolCallV2]
        """
        return self._tool_calls

    @tool_calls.setter
    def tool_calls(self, tool_calls):
        """
        Sets the tool_calls of this CohereAssistantMessageV2.
        A list of tool calls generated by the model.


        :param tool_calls: The tool_calls of this CohereAssistantMessageV2.
        :type: list[oci.generative_ai_inference.models.CohereToolCallV2]
        """
        self._tool_calls = tool_calls

    @property
    def citations(self):
        """
        Gets the citations of this CohereAssistantMessageV2.
        Cohere citations


        :return: The citations of this CohereAssistantMessageV2.
        :rtype: list[oci.generative_ai_inference.models.CohereCitationV2]
        """
        return self._citations

    @citations.setter
    def citations(self, citations):
        """
        Sets the citations of this CohereAssistantMessageV2.
        Cohere citations


        :param citations: The citations of this CohereAssistantMessageV2.
        :type: list[oci.generative_ai_inference.models.CohereCitationV2]
        """
        self._citations = citations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
