# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereCitationV2(object):
    """
    A source reference or citation for a piece of content.
    """

    #: A constant which can be used with the type property of a CohereCitationV2.
    #: This constant has a value of "TEXT_CONTENT"
    TYPE_TEXT_CONTENT = "TEXT_CONTENT"

    #: A constant which can be used with the type property of a CohereCitationV2.
    #: This constant has a value of "THINKING_CONTENT"
    TYPE_THINKING_CONTENT = "THINKING_CONTENT"

    #: A constant which can be used with the type property of a CohereCitationV2.
    #: This constant has a value of "PLAN"
    TYPE_PLAN = "PLAN"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereCitationV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param start:
            The value to assign to the start property of this CohereCitationV2.
        :type start: int

        :param end:
            The value to assign to the end property of this CohereCitationV2.
        :type end: int

        :param text:
            The value to assign to the text property of this CohereCitationV2.
        :type text: str

        :param content_index:
            The value to assign to the content_index property of this CohereCitationV2.
        :type content_index: int

        :param type:
            The value to assign to the type property of this CohereCitationV2.
            Allowed values for this property are: "TEXT_CONTENT", "THINKING_CONTENT", "PLAN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param sources:
            The value to assign to the sources property of this CohereCitationV2.
        :type sources: list[oci.generative_ai_inference.models.CohereCitationSourceV2]

        """
        self.swagger_types = {
            'start': 'int',
            'end': 'int',
            'text': 'str',
            'content_index': 'int',
            'type': 'str',
            'sources': 'list[CohereCitationSourceV2]'
        }
        self.attribute_map = {
            'start': 'start',
            'end': 'end',
            'text': 'text',
            'content_index': 'contentIndex',
            'type': 'type',
            'sources': 'sources'
        }
        self._start = None
        self._end = None
        self._text = None
        self._content_index = None
        self._type = None
        self._sources = None

    @property
    def start(self):
        """
        Gets the start of this CohereCitationV2.
        Start index of the cited snippet in the original source text.


        :return: The start of this CohereCitationV2.
        :rtype: int
        """
        return self._start

    @start.setter
    def start(self, start):
        """
        Sets the start of this CohereCitationV2.
        Start index of the cited snippet in the original source text.


        :param start: The start of this CohereCitationV2.
        :type: int
        """
        self._start = start

    @property
    def end(self):
        """
        Gets the end of this CohereCitationV2.
        End index of the cited snippet in the original source text.


        :return: The end of this CohereCitationV2.
        :rtype: int
        """
        return self._end

    @end.setter
    def end(self, end):
        """
        Sets the end of this CohereCitationV2.
        End index of the cited snippet in the original source text.


        :param end: The end of this CohereCitationV2.
        :type: int
        """
        self._end = end

    @property
    def text(self):
        """
        Gets the text of this CohereCitationV2.
        Text snippet that is being cited.


        :return: The text of this CohereCitationV2.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this CohereCitationV2.
        Text snippet that is being cited.


        :param text: The text of this CohereCitationV2.
        :type: str
        """
        self._text = text

    @property
    def content_index(self):
        """
        Gets the content_index of this CohereCitationV2.
        Index of the content block in which this citation appears.


        :return: The content_index of this CohereCitationV2.
        :rtype: int
        """
        return self._content_index

    @content_index.setter
    def content_index(self, content_index):
        """
        Sets the content_index of this CohereCitationV2.
        Index of the content block in which this citation appears.


        :param content_index: The content_index of this CohereCitationV2.
        :type: int
        """
        self._content_index = content_index

    @property
    def type(self):
        """
        Gets the type of this CohereCitationV2.
        The type of citation indicating what part of the response it is for.

        Allowed values for this property are: "TEXT_CONTENT", "THINKING_CONTENT", "PLAN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this CohereCitationV2.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CohereCitationV2.
        The type of citation indicating what part of the response it is for.


        :param type: The type of this CohereCitationV2.
        :type: str
        """
        allowed_values = ["TEXT_CONTENT", "THINKING_CONTENT", "PLAN"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def sources(self):
        """
        Gets the sources of this CohereCitationV2.
        List of source objects for this citation.


        :return: The sources of this CohereCitationV2.
        :rtype: list[oci.generative_ai_inference.models.CohereCitationSourceV2]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """
        Sets the sources of this CohereCitationV2.
        List of source objects for this citation.


        :param sources: The sources of this CohereCitationV2.
        :type: list[oci.generative_ai_inference.models.CohereCitationSourceV2]
        """
        self._sources = sources

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
