# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereImageUrlV2(object):
    """
    Provide a base64 encoded image or an image uri if it's supported.
    """

    #: A constant which can be used with the detail property of a CohereImageUrlV2.
    #: This constant has a value of "AUTO"
    DETAIL_AUTO = "AUTO"

    #: A constant which can be used with the detail property of a CohereImageUrlV2.
    #: This constant has a value of "HIGH"
    DETAIL_HIGH = "HIGH"

    #: A constant which can be used with the detail property of a CohereImageUrlV2.
    #: This constant has a value of "LOW"
    DETAIL_LOW = "LOW"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereImageUrlV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param url:
            The value to assign to the url property of this CohereImageUrlV2.
        :type url: str

        :param detail:
            The value to assign to the detail property of this CohereImageUrlV2.
            Allowed values for this property are: "AUTO", "HIGH", "LOW", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type detail: str

        """
        self.swagger_types = {
            'url': 'str',
            'detail': 'str'
        }
        self.attribute_map = {
            'url': 'url',
            'detail': 'detail'
        }
        self._url = None
        self._detail = None

    @property
    def url(self):
        """
        **[Required]** Gets the url of this CohereImageUrlV2.
        URL of an image. Can be either a base64 data URI or a web URL (type can be either image_url or text).


        :return: The url of this CohereImageUrlV2.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this CohereImageUrlV2.
        URL of an image. Can be either a base64 data URI or a web URL (type can be either image_url or text).


        :param url: The url of this CohereImageUrlV2.
        :type: str
        """
        self._url = url

    @property
    def detail(self):
        """
        Gets the detail of this CohereImageUrlV2.
        Controls the level of detail in image processing. \"auto\" is the default and lets the system choose, \"low\" is faster but less detailed, and \"high\" preserves maximum detail. You can save tokens and speed up responses by using detail \"low\".

        Allowed values for this property are: "AUTO", "HIGH", "LOW", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The detail of this CohereImageUrlV2.
        :rtype: str
        """
        return self._detail

    @detail.setter
    def detail(self, detail):
        """
        Sets the detail of this CohereImageUrlV2.
        Controls the level of detail in image processing. \"auto\" is the default and lets the system choose, \"low\" is faster but less detailed, and \"high\" preserves maximum detail. You can save tokens and speed up responses by using detail \"low\".


        :param detail: The detail of this CohereImageUrlV2.
        :type: str
        """
        allowed_values = ["AUTO", "HIGH", "LOW"]
        if not value_allowed_none_or_none_sentinel(detail, allowed_values):
            detail = 'UNKNOWN_ENUM_VALUE'
        self._detail = detail

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
