# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CompletionTokensDetails(object):
    """
    Breakdown of tokens used in a completion.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CompletionTokensDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param accepted_prediction_tokens:
            The value to assign to the accepted_prediction_tokens property of this CompletionTokensDetails.
        :type accepted_prediction_tokens: int

        :param reasoning_tokens:
            The value to assign to the reasoning_tokens property of this CompletionTokensDetails.
        :type reasoning_tokens: int

        :param rejected_prediction_tokens:
            The value to assign to the rejected_prediction_tokens property of this CompletionTokensDetails.
        :type rejected_prediction_tokens: int

        """
        self.swagger_types = {
            'accepted_prediction_tokens': 'int',
            'reasoning_tokens': 'int',
            'rejected_prediction_tokens': 'int'
        }
        self.attribute_map = {
            'accepted_prediction_tokens': 'acceptedPredictionTokens',
            'reasoning_tokens': 'reasoningTokens',
            'rejected_prediction_tokens': 'rejectedPredictionTokens'
        }
        self._accepted_prediction_tokens = None
        self._reasoning_tokens = None
        self._rejected_prediction_tokens = None

    @property
    def accepted_prediction_tokens(self):
        """
        Gets the accepted_prediction_tokens of this CompletionTokensDetails.
        When using Predicted Outputs, the number of tokens in the prediction that appeared in the completion.


        :return: The accepted_prediction_tokens of this CompletionTokensDetails.
        :rtype: int
        """
        return self._accepted_prediction_tokens

    @accepted_prediction_tokens.setter
    def accepted_prediction_tokens(self, accepted_prediction_tokens):
        """
        Sets the accepted_prediction_tokens of this CompletionTokensDetails.
        When using Predicted Outputs, the number of tokens in the prediction that appeared in the completion.


        :param accepted_prediction_tokens: The accepted_prediction_tokens of this CompletionTokensDetails.
        :type: int
        """
        self._accepted_prediction_tokens = accepted_prediction_tokens

    @property
    def reasoning_tokens(self):
        """
        Gets the reasoning_tokens of this CompletionTokensDetails.
        Tokens generated by the model for reasoning.


        :return: The reasoning_tokens of this CompletionTokensDetails.
        :rtype: int
        """
        return self._reasoning_tokens

    @reasoning_tokens.setter
    def reasoning_tokens(self, reasoning_tokens):
        """
        Sets the reasoning_tokens of this CompletionTokensDetails.
        Tokens generated by the model for reasoning.


        :param reasoning_tokens: The reasoning_tokens of this CompletionTokensDetails.
        :type: int
        """
        self._reasoning_tokens = reasoning_tokens

    @property
    def rejected_prediction_tokens(self):
        """
        Gets the rejected_prediction_tokens of this CompletionTokensDetails.
        When using Predicted Outputs, the number of tokens in the prediction that did not appear in the completion. However, like reasoning tokens, these tokens are still counted in the total completion tokens for purposes of billing, output, and context window limits.


        :return: The rejected_prediction_tokens of this CompletionTokensDetails.
        :rtype: int
        """
        return self._rejected_prediction_tokens

    @rejected_prediction_tokens.setter
    def rejected_prediction_tokens(self, rejected_prediction_tokens):
        """
        Sets the rejected_prediction_tokens of this CompletionTokensDetails.
        When using Predicted Outputs, the number of tokens in the prediction that did not appear in the completion. However, like reasoning tokens, these tokens are still counted in the total completion tokens for purposes of billing, output, and context window limits.


        :param rejected_prediction_tokens: The rejected_prediction_tokens of this CompletionTokensDetails.
        :type: int
        """
        self._rejected_prediction_tokens = rejected_prediction_tokens

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
