# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .serving_mode import ServingMode
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DedicatedServingMode(ServingMode):
    """
    The model's serving mode is dedicated serving and has an endpoint on a dedicated AI cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DedicatedServingMode object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.DedicatedServingMode.serving_type` attribute
        of this class is ``DEDICATED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param serving_type:
            The value to assign to the serving_type property of this DedicatedServingMode.
            Allowed values for this property are: "ON_DEMAND", "DEDICATED"
        :type serving_type: str

        :param endpoint_id:
            The value to assign to the endpoint_id property of this DedicatedServingMode.
        :type endpoint_id: str

        """
        self.swagger_types = {
            'serving_type': 'str',
            'endpoint_id': 'str'
        }
        self.attribute_map = {
            'serving_type': 'servingType',
            'endpoint_id': 'endpointId'
        }
        self._serving_type = None
        self._endpoint_id = None
        self._serving_type = 'DEDICATED'

    @property
    def endpoint_id(self):
        """
        **[Required]** Gets the endpoint_id of this DedicatedServingMode.
        The OCID of the endpoint to use.


        :return: The endpoint_id of this DedicatedServingMode.
        :rtype: str
        """
        return self._endpoint_id

    @endpoint_id.setter
    def endpoint_id(self, endpoint_id):
        """
        Sets the endpoint_id of this DedicatedServingMode.
        The OCID of the endpoint to use.


        :param endpoint_id: The endpoint_id of this DedicatedServingMode.
        :type: str
        """
        self._endpoint_id = endpoint_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
