# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .chat_content import ChatContent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DocumentContent(ChatContent):
    """
    Represents a single instance of chat document content.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DocumentContent object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.DocumentContent.type` attribute
        of this class is ``DOCUMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DocumentContent.
            Allowed values for this property are: "TEXT", "IMAGE"
        :type type: str

        :param document_url:
            The value to assign to the document_url property of this DocumentContent.
        :type document_url: oci.generative_ai_inference.models.DocumentUrl

        """
        self.swagger_types = {
            'type': 'str',
            'document_url': 'DocumentUrl'
        }
        self.attribute_map = {
            'type': 'type',
            'document_url': 'documentUrl'
        }
        self._type = None
        self._document_url = None
        self._type = 'DOCUMENT'

    @property
    def document_url(self):
        """
        Gets the document_url of this DocumentContent.

        :return: The document_url of this DocumentContent.
        :rtype: oci.generative_ai_inference.models.DocumentUrl
        """
        return self._document_url

    @document_url.setter
    def document_url(self, document_url):
        """
        Sets the document_url of this DocumentContent.

        :param document_url: The document_url of this DocumentContent.
        :type: oci.generative_ai_inference.models.DocumentUrl
        """
        self._document_url = document_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
