# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GroundingSupportSegment(object):
    """
    segment within groundingSupport.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GroundingSupportSegment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param start_index:
            The value to assign to the start_index property of this GroundingSupportSegment.
        :type start_index: int

        :param end_index:
            The value to assign to the end_index property of this GroundingSupportSegment.
        :type end_index: int

        :param text:
            The value to assign to the text property of this GroundingSupportSegment.
        :type text: str

        """
        self.swagger_types = {
            'start_index': 'int',
            'end_index': 'int',
            'text': 'str'
        }
        self.attribute_map = {
            'start_index': 'startIndex',
            'end_index': 'endIndex',
            'text': 'text'
        }
        self._start_index = None
        self._end_index = None
        self._text = None

    @property
    def start_index(self):
        """
        Gets the start_index of this GroundingSupportSegment.
        The start index


        :return: The start_index of this GroundingSupportSegment.
        :rtype: int
        """
        return self._start_index

    @start_index.setter
    def start_index(self, start_index):
        """
        Sets the start_index of this GroundingSupportSegment.
        The start index


        :param start_index: The start_index of this GroundingSupportSegment.
        :type: int
        """
        self._start_index = start_index

    @property
    def end_index(self):
        """
        Gets the end_index of this GroundingSupportSegment.
        The end index


        :return: The end_index of this GroundingSupportSegment.
        :rtype: int
        """
        return self._end_index

    @end_index.setter
    def end_index(self, end_index):
        """
        Sets the end_index of this GroundingSupportSegment.
        The end index


        :param end_index: The end_index of this GroundingSupportSegment.
        :type: int
        """
        self._end_index = end_index

    @property
    def text(self):
        """
        Gets the text of this GroundingSupportSegment.
        the text in the segment


        :return: The text of this GroundingSupportSegment.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this GroundingSupportSegment.
        the text in the segment


        :param text: The text of this GroundingSupportSegment.
        :type: str
        """
        self._text = text

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
