# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogProbability(object):
    """
    The log probabilities of the generated tokens.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LogProbability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param token_ids:
            The value to assign to the token_ids property of this LogProbability.
        :type token_ids: list[int]

        :param text:
            The value to assign to the text property of this LogProbability.
        :type text: str

        :param log_probabilities:
            The value to assign to the log_probabilities property of this LogProbability.
        :type log_probabilities: list[float]

        """
        self.swagger_types = {
            'token_ids': 'list[int]',
            'text': 'str',
            'log_probabilities': 'list[float]'
        }
        self.attribute_map = {
            'token_ids': 'tokenIds',
            'text': 'text',
            'log_probabilities': 'logProbabilities'
        }
        self._token_ids = None
        self._text = None
        self._log_probabilities = None

    @property
    def token_ids(self):
        """
        Gets the token_ids of this LogProbability.
        The token ids of each token used to construct the text chunk.


        :return: The token_ids of this LogProbability.
        :rtype: list[int]
        """
        return self._token_ids

    @token_ids.setter
    def token_ids(self, token_ids):
        """
        Sets the token_ids of this LogProbability.
        The token ids of each token used to construct the text chunk.


        :param token_ids: The token_ids of this LogProbability.
        :type: list[int]
        """
        self._token_ids = token_ids

    @property
    def text(self):
        """
        Gets the text of this LogProbability.
        The text chunk for which the log probabilities was calculated.


        :return: The text of this LogProbability.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this LogProbability.
        The text chunk for which the log probabilities was calculated.


        :param text: The text of this LogProbability.
        :type: str
        """
        self._text = text

    @property
    def log_probabilities(self):
        """
        Gets the log_probabilities of this LogProbability.
        The log probability of each token used to construct the text chunk.


        :return: The log_probabilities of this LogProbability.
        :rtype: list[float]
        """
        return self._log_probabilities

    @log_probabilities.setter
    def log_probabilities(self, log_probabilities):
        """
        Sets the log_probabilities of this LogProbability.
        The log probability of each token used to construct the text chunk.


        :param log_probabilities: The log_probabilities of this LogProbability.
        :type: list[float]
        """
        self._log_probabilities = log_probabilities

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
