# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PromptTokensDetails(object):
    """
    Breakdown of tokens used in the prompt.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PromptTokensDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cached_tokens:
            The value to assign to the cached_tokens property of this PromptTokensDetails.
        :type cached_tokens: int

        """
        self.swagger_types = {
            'cached_tokens': 'int'
        }
        self.attribute_map = {
            'cached_tokens': 'cachedTokens'
        }
        self._cached_tokens = None

    @property
    def cached_tokens(self):
        """
        Gets the cached_tokens of this PromptTokensDetails.
        Cached tokens present in the prompt.


        :return: The cached_tokens of this PromptTokensDetails.
        :rtype: int
        """
        return self._cached_tokens

    @cached_tokens.setter
    def cached_tokens(self, cached_tokens):
        """
        Sets the cached_tokens of this PromptTokensDetails.
        Cached tokens present in the prompt.


        :param cached_tokens: The cached_tokens of this PromptTokensDetails.
        :type: int
        """
        self._cached_tokens = cached_tokens

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
