# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RerankTextDetails(object):
    """
    Details required for a rerank request.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RerankTextDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param input:
            The value to assign to the input property of this RerankTextDetails.
        :type input: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RerankTextDetails.
        :type compartment_id: str

        :param serving_mode:
            The value to assign to the serving_mode property of this RerankTextDetails.
        :type serving_mode: oci.generative_ai_inference.models.ServingMode

        :param documents:
            The value to assign to the documents property of this RerankTextDetails.
        :type documents: list[str]

        :param top_n:
            The value to assign to the top_n property of this RerankTextDetails.
        :type top_n: int

        :param is_echo:
            The value to assign to the is_echo property of this RerankTextDetails.
        :type is_echo: bool

        :param max_chunks_per_document:
            The value to assign to the max_chunks_per_document property of this RerankTextDetails.
        :type max_chunks_per_document: int

        :param max_tokens_per_document:
            The value to assign to the max_tokens_per_document property of this RerankTextDetails.
        :type max_tokens_per_document: int

        """
        self.swagger_types = {
            'input': 'str',
            'compartment_id': 'str',
            'serving_mode': 'ServingMode',
            'documents': 'list[str]',
            'top_n': 'int',
            'is_echo': 'bool',
            'max_chunks_per_document': 'int',
            'max_tokens_per_document': 'int'
        }
        self.attribute_map = {
            'input': 'input',
            'compartment_id': 'compartmentId',
            'serving_mode': 'servingMode',
            'documents': 'documents',
            'top_n': 'topN',
            'is_echo': 'isEcho',
            'max_chunks_per_document': 'maxChunksPerDocument',
            'max_tokens_per_document': 'maxTokensPerDocument'
        }
        self._input = None
        self._compartment_id = None
        self._serving_mode = None
        self._documents = None
        self._top_n = None
        self._is_echo = None
        self._max_chunks_per_document = None
        self._max_tokens_per_document = None

    @property
    def input(self):
        """
        **[Required]** Gets the input of this RerankTextDetails.
        Input query for search in the documents.


        :return: The input of this RerankTextDetails.
        :rtype: str
        """
        return self._input

    @input.setter
    def input(self, input):
        """
        Sets the input of this RerankTextDetails.
        Input query for search in the documents.


        :param input: The input of this RerankTextDetails.
        :type: str
        """
        self._input = input

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RerankTextDetails.
        The OCID of the compartment to call into the Generative AI service LLMs.


        :return: The compartment_id of this RerankTextDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RerankTextDetails.
        The OCID of the compartment to call into the Generative AI service LLMs.


        :param compartment_id: The compartment_id of this RerankTextDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def serving_mode(self):
        """
        **[Required]** Gets the serving_mode of this RerankTextDetails.

        :return: The serving_mode of this RerankTextDetails.
        :rtype: oci.generative_ai_inference.models.ServingMode
        """
        return self._serving_mode

    @serving_mode.setter
    def serving_mode(self, serving_mode):
        """
        Sets the serving_mode of this RerankTextDetails.

        :param serving_mode: The serving_mode of this RerankTextDetails.
        :type: oci.generative_ai_inference.models.ServingMode
        """
        self._serving_mode = serving_mode

    @property
    def documents(self):
        """
        **[Required]** Gets the documents of this RerankTextDetails.
        A list of document strings to rerank based on the query asked.


        :return: The documents of this RerankTextDetails.
        :rtype: list[str]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this RerankTextDetails.
        A list of document strings to rerank based on the query asked.


        :param documents: The documents of this RerankTextDetails.
        :type: list[str]
        """
        self._documents = documents

    @property
    def top_n(self):
        """
        Gets the top_n of this RerankTextDetails.
        The number of most relevant documents or indices to return. Defaults to the length of the documents.


        :return: The top_n of this RerankTextDetails.
        :rtype: int
        """
        return self._top_n

    @top_n.setter
    def top_n(self, top_n):
        """
        Sets the top_n of this RerankTextDetails.
        The number of most relevant documents or indices to return. Defaults to the length of the documents.


        :param top_n: The top_n of this RerankTextDetails.
        :type: int
        """
        self._top_n = top_n

    @property
    def is_echo(self):
        """
        Gets the is_echo of this RerankTextDetails.
        Whether or not to return the documents in the response.


        :return: The is_echo of this RerankTextDetails.
        :rtype: bool
        """
        return self._is_echo

    @is_echo.setter
    def is_echo(self, is_echo):
        """
        Sets the is_echo of this RerankTextDetails.
        Whether or not to return the documents in the response.


        :param is_echo: The is_echo of this RerankTextDetails.
        :type: bool
        """
        self._is_echo = is_echo

    @property
    def max_chunks_per_document(self):
        """
        Gets the max_chunks_per_document of this RerankTextDetails.
        The maximum number of chunks to produce internally from a document.


        :return: The max_chunks_per_document of this RerankTextDetails.
        :rtype: int
        """
        return self._max_chunks_per_document

    @max_chunks_per_document.setter
    def max_chunks_per_document(self, max_chunks_per_document):
        """
        Sets the max_chunks_per_document of this RerankTextDetails.
        The maximum number of chunks to produce internally from a document.


        :param max_chunks_per_document: The max_chunks_per_document of this RerankTextDetails.
        :type: int
        """
        self._max_chunks_per_document = max_chunks_per_document

    @property
    def max_tokens_per_document(self):
        """
        Gets the max_tokens_per_document of this RerankTextDetails.
        Used to truncate the long documents with the specified no of tokens.


        :return: The max_tokens_per_document of this RerankTextDetails.
        :rtype: int
        """
        return self._max_tokens_per_document

    @max_tokens_per_document.setter
    def max_tokens_per_document(self, max_tokens_per_document):
        """
        Sets the max_tokens_per_document of this RerankTextDetails.
        Used to truncate the long documents with the specified no of tokens.


        :param max_tokens_per_document: The max_tokens_per_document of this RerankTextDetails.
        :type: int
        """
        self._max_tokens_per_document = max_tokens_per_document

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
