# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeploymentPlacementInfo(object):
    """
    Specifies a deployment placement with explicit availability and fault domain specification.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DeploymentPlacementInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this DeploymentPlacementInfo.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this DeploymentPlacementInfo.
        :type fault_domain: str

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'fault_domain': 'str'
        }
        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain'
        }
        self._availability_domain = None
        self._fault_domain = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this DeploymentPlacementInfo.
        The availability domain of a placement.


        :return: The availability_domain of this DeploymentPlacementInfo.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this DeploymentPlacementInfo.
        The availability domain of a placement.


        :param availability_domain: The availability_domain of this DeploymentPlacementInfo.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        **[Required]** Gets the fault_domain of this DeploymentPlacementInfo.
        The fault domain of a placement.


        :return: The fault_domain of this DeploymentPlacementInfo.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this DeploymentPlacementInfo.
        The fault domain of a placement.


        :param fault_domain: The fault_domain of this DeploymentPlacementInfo.
        :type: str
        """
        self._fault_domain = fault_domain

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
