# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MappedAttribute(object):
    """
    Schema for MappedAttribute resource.
    """

    #: A constant which can be used with the idcs_prevented_operations property of a MappedAttribute.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a MappedAttribute.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a MappedAttribute.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    #: A constant which can be used with the idcs_resource_type property of a MappedAttribute.
    #: This constant has a value of "User"
    IDCS_RESOURCE_TYPE_USER = "User"

    #: A constant which can be used with the idcs_resource_type property of a MappedAttribute.
    #: This constant has a value of "Group"
    IDCS_RESOURCE_TYPE_GROUP = "Group"

    #: A constant which can be used with the idcs_resource_type property of a MappedAttribute.
    #: This constant has a value of "Container"
    IDCS_RESOURCE_TYPE_CONTAINER = "Container"

    #: A constant which can be used with the ref_resource_type property of a MappedAttribute.
    #: This constant has a value of "AccountObjectClass"
    REF_RESOURCE_TYPE_ACCOUNT_OBJECT_CLASS = "AccountObjectClass"

    #: A constant which can be used with the ref_resource_type property of a MappedAttribute.
    #: This constant has a value of "App"
    REF_RESOURCE_TYPE_APP = "App"

    #: A constant which can be used with the ref_resource_type property of a MappedAttribute.
    #: This constant has a value of "ManagedObjectClass"
    REF_RESOURCE_TYPE_MANAGED_OBJECT_CLASS = "ManagedObjectClass"

    #: A constant which can be used with the ref_resource_type property of a MappedAttribute.
    #: This constant has a value of "IdentityProvider"
    REF_RESOURCE_TYPE_IDENTITY_PROVIDER = "IdentityProvider"

    #: A constant which can be used with the direction property of a MappedAttribute.
    #: This constant has a value of "inbound"
    DIRECTION_INBOUND = "inbound"

    #: A constant which can be used with the direction property of a MappedAttribute.
    #: This constant has a value of "outbound"
    DIRECTION_OUTBOUND = "outbound"

    def __init__(self, **kwargs):
        """
        Initializes a new MappedAttribute object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MappedAttribute.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this MappedAttribute.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this MappedAttribute.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this MappedAttribute.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this MappedAttribute.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this MappedAttribute.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this MappedAttribute.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this MappedAttribute.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this MappedAttribute.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this MappedAttribute.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this MappedAttribute.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this MappedAttribute.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this MappedAttribute.
        :type tenancy_ocid: str

        :param idcs_resource_type:
            The value to assign to the idcs_resource_type property of this MappedAttribute.
            Allowed values for this property are: "User", "Group", "Container", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_resource_type: str

        :param ref_resource_type:
            The value to assign to the ref_resource_type property of this MappedAttribute.
            Allowed values for this property are: "AccountObjectClass", "App", "ManagedObjectClass", "IdentityProvider", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type ref_resource_type: str

        :param ref_resource_id:
            The value to assign to the ref_resource_id property of this MappedAttribute.
        :type ref_resource_id: str

        :param direction:
            The value to assign to the direction property of this MappedAttribute.
            Allowed values for this property are: "inbound", "outbound", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type direction: str

        :param attribute_mappings:
            The value to assign to the attribute_mappings property of this MappedAttribute.
        :type attribute_mappings: list[oci.identity_domains.models.MappedAttributeAttributeMappings]

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'idcs_resource_type': 'str',
            'ref_resource_type': 'str',
            'ref_resource_id': 'str',
            'direction': 'str',
            'attribute_mappings': 'list[MappedAttributeAttributeMappings]'
        }
        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'idcs_resource_type': 'idcsResourceType',
            'ref_resource_type': 'refResourceType',
            'ref_resource_id': 'refResourceID',
            'direction': 'direction',
            'attribute_mappings': 'attributeMappings'
        }
        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._idcs_resource_type = None
        self._ref_resource_type = None
        self._ref_resource_id = None
        self._direction = None
        self._attribute_mappings = None

    @property
    def id(self):
        """
        Gets the id of this MappedAttribute.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this MappedAttribute.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MappedAttribute.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this MappedAttribute.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this MappedAttribute.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this MappedAttribute.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this MappedAttribute.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this MappedAttribute.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this MappedAttribute.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this MappedAttribute.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this MappedAttribute.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this MappedAttribute.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this MappedAttribute.

        :return: The meta of this MappedAttribute.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this MappedAttribute.

        :param meta: The meta of this MappedAttribute.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this MappedAttribute.

        :return: The idcs_created_by of this MappedAttribute.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this MappedAttribute.

        :param idcs_created_by: The idcs_created_by of this MappedAttribute.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this MappedAttribute.

        :return: The idcs_last_modified_by of this MappedAttribute.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this MappedAttribute.

        :param idcs_last_modified_by: The idcs_last_modified_by of this MappedAttribute.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this MappedAttribute.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this MappedAttribute.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this MappedAttribute.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this MappedAttribute.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this MappedAttribute.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this MappedAttribute.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this MappedAttribute.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this MappedAttribute.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this MappedAttribute.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this MappedAttribute.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this MappedAttribute.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this MappedAttribute.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this MappedAttribute.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this MappedAttribute.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this MappedAttribute.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this MappedAttribute.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this MappedAttribute.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this MappedAttribute.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this MappedAttribute.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this MappedAttribute.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this MappedAttribute.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this MappedAttribute.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this MappedAttribute.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this MappedAttribute.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this MappedAttribute.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this MappedAttribute.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this MappedAttribute.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this MappedAttribute.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def idcs_resource_type(self):
        """
        **[Required]** Gets the idcs_resource_type of this MappedAttribute.
        The Oracle Identity Cloud Service Resource Type for which the mapping is being done

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "User", "Group", "Container", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_resource_type of this MappedAttribute.
        :rtype: str
        """
        return self._idcs_resource_type

    @idcs_resource_type.setter
    def idcs_resource_type(self, idcs_resource_type):
        """
        Sets the idcs_resource_type of this MappedAttribute.
        The Oracle Identity Cloud Service Resource Type for which the mapping is being done

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_resource_type: The idcs_resource_type of this MappedAttribute.
        :type: str
        """
        allowed_values = ["User", "Group", "Container"]
        if not value_allowed_none_or_none_sentinel(idcs_resource_type, allowed_values):
            idcs_resource_type = 'UNKNOWN_ENUM_VALUE'
        self._idcs_resource_type = idcs_resource_type

    @property
    def ref_resource_type(self):
        """
        **[Required]** Gets the ref_resource_type of this MappedAttribute.
        The Reference Resource Type that holds the mapping

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "AccountObjectClass", "App", "ManagedObjectClass", "IdentityProvider", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The ref_resource_type of this MappedAttribute.
        :rtype: str
        """
        return self._ref_resource_type

    @ref_resource_type.setter
    def ref_resource_type(self, ref_resource_type):
        """
        Sets the ref_resource_type of this MappedAttribute.
        The Reference Resource Type that holds the mapping

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param ref_resource_type: The ref_resource_type of this MappedAttribute.
        :type: str
        """
        allowed_values = ["AccountObjectClass", "App", "ManagedObjectClass", "IdentityProvider"]
        if not value_allowed_none_or_none_sentinel(ref_resource_type, allowed_values):
            ref_resource_type = 'UNKNOWN_ENUM_VALUE'
        self._ref_resource_type = ref_resource_type

    @property
    def ref_resource_id(self):
        """
        **[Required]** Gets the ref_resource_id of this MappedAttribute.
        Soft Reference to store Resource ID that holds the mapping

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The ref_resource_id of this MappedAttribute.
        :rtype: str
        """
        return self._ref_resource_id

    @ref_resource_id.setter
    def ref_resource_id(self, ref_resource_id):
        """
        Sets the ref_resource_id of this MappedAttribute.
        Soft Reference to store Resource ID that holds the mapping

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param ref_resource_id: The ref_resource_id of this MappedAttribute.
        :type: str
        """
        self._ref_resource_id = ref_resource_id

    @property
    def direction(self):
        """
        **[Required]** Gets the direction of this MappedAttribute.
        Direction of the attribute mapping. inbound indicates mapping is from source ManagedObjectClass to Oracle Identity Cloud Service ResourceType. outbound indicates mapping is from Oracle Identity Cloud Service Resource Type to target ManagedObjectClass.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "inbound", "outbound", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The direction of this MappedAttribute.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """
        Sets the direction of this MappedAttribute.
        Direction of the attribute mapping. inbound indicates mapping is from source ManagedObjectClass to Oracle Identity Cloud Service ResourceType. outbound indicates mapping is from Oracle Identity Cloud Service Resource Type to target ManagedObjectClass.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param direction: The direction of this MappedAttribute.
        :type: str
        """
        allowed_values = ["inbound", "outbound"]
        if not value_allowed_none_or_none_sentinel(direction, allowed_values):
            direction = 'UNKNOWN_ENUM_VALUE'
        self._direction = direction

    @property
    def attribute_mappings(self):
        """
        Gets the attribute_mappings of this MappedAttribute.
        A list of attribute mappings between Oracle Identity Cloud Service Resource Type and Account Object Class

        **SCIM++ Properties:**
         - idcsCompositeKey: [idcsAttributeName, managedObjectAttributeName]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The attribute_mappings of this MappedAttribute.
        :rtype: list[oci.identity_domains.models.MappedAttributeAttributeMappings]
        """
        return self._attribute_mappings

    @attribute_mappings.setter
    def attribute_mappings(self, attribute_mappings):
        """
        Sets the attribute_mappings of this MappedAttribute.
        A list of attribute mappings between Oracle Identity Cloud Service Resource Type and Account Object Class

        **SCIM++ Properties:**
         - idcsCompositeKey: [idcsAttributeName, managedObjectAttributeName]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param attribute_mappings: The attribute_mappings of this MappedAttribute.
        :type: list[oci.identity_domains.models.MappedAttributeAttributeMappings]
        """
        self._attribute_mappings = attribute_mappings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
