# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610

from .task_details import TaskDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeployedApplicationMigrationTaskDetails(TaskDetails):
    """
    The task details with deployed application migration related information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DeployedApplicationMigrationTaskDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.jms.models.DeployedApplicationMigrationTaskDetails.task_type` attribute
        of this class is ``DEPLOYED_APPLICATION_MIGRATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param task_type:
            The value to assign to the task_type property of this DeployedApplicationMigrationTaskDetails.
            Allowed values for this property are: "CRYPTO", "JFR", "SCAN_LIBRARY", "SCAN_JAVA_SERVER", "JAVA_MIGRATION", "DEPLOYED_APPLICATION_MIGRATION", "PERFORMANCE_TUNING", "ADD_INSTALLATION_SITE", "REMOVE_INSTALLATION_SITE"
        :type task_type: str

        :param deployed_application_migration_task_request:
            The value to assign to the deployed_application_migration_task_request property of this DeployedApplicationMigrationTaskDetails.
        :type deployed_application_migration_task_request: oci.jms.models.RequestDeployedApplicationMigrationAnalysesDetails

        """
        self.swagger_types = {
            'task_type': 'str',
            'deployed_application_migration_task_request': 'RequestDeployedApplicationMigrationAnalysesDetails'
        }
        self.attribute_map = {
            'task_type': 'taskType',
            'deployed_application_migration_task_request': 'deployedApplicationMigrationTaskRequest'
        }
        self._task_type = None
        self._deployed_application_migration_task_request = None
        self._task_type = 'DEPLOYED_APPLICATION_MIGRATION'

    @property
    def deployed_application_migration_task_request(self):
        """
        Gets the deployed_application_migration_task_request of this DeployedApplicationMigrationTaskDetails.

        :return: The deployed_application_migration_task_request of this DeployedApplicationMigrationTaskDetails.
        :rtype: oci.jms.models.RequestDeployedApplicationMigrationAnalysesDetails
        """
        return self._deployed_application_migration_task_request

    @deployed_application_migration_task_request.setter
    def deployed_application_migration_task_request(self, deployed_application_migration_task_request):
        """
        Sets the deployed_application_migration_task_request of this DeployedApplicationMigrationTaskDetails.

        :param deployed_application_migration_task_request: The deployed_application_migration_task_request of this DeployedApplicationMigrationTaskDetails.
        :type: oci.jms.models.RequestDeployedApplicationMigrationAnalysesDetails
        """
        self._deployed_application_migration_task_request = deployed_application_migration_task_request

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
