# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PluginErrorDetails(object):
    """
    Details of a plugin error.
    """

    #: A constant which can be used with the reason property of a PluginErrorDetails.
    #: This constant has a value of "REGISTRATION_POLICY"
    REASON_REGISTRATION_POLICY = "REGISTRATION_POLICY"

    #: A constant which can be used with the reason property of a PluginErrorDetails.
    #: This constant has a value of "LOG_RESOURCE_POLICY"
    REASON_LOG_RESOURCE_POLICY = "LOG_RESOURCE_POLICY"

    #: A constant which can be used with the reason property of a PluginErrorDetails.
    #: This constant has a value of "NO_FLEET"
    REASON_NO_FLEET = "NO_FLEET"

    def __init__(self, **kwargs):
        """
        Initializes a new PluginErrorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reason:
            The value to assign to the reason property of this PluginErrorDetails.
            Allowed values for this property are: "REGISTRATION_POLICY", "LOG_RESOURCE_POLICY", "NO_FLEET", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type reason: str

        :param details:
            The value to assign to the details property of this PluginErrorDetails.
        :type details: str

        :param time_last_seen:
            The value to assign to the time_last_seen property of this PluginErrorDetails.
        :type time_last_seen: datetime

        """
        self.swagger_types = {
            'reason': 'str',
            'details': 'str',
            'time_last_seen': 'datetime'
        }
        self.attribute_map = {
            'reason': 'reason',
            'details': 'details',
            'time_last_seen': 'timeLastSeen'
        }
        self._reason = None
        self._details = None
        self._time_last_seen = None

    @property
    def reason(self):
        """
        **[Required]** Gets the reason of this PluginErrorDetails.
        The plugin error reason.

        Allowed values for this property are: "REGISTRATION_POLICY", "LOG_RESOURCE_POLICY", "NO_FLEET", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The reason of this PluginErrorDetails.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """
        Sets the reason of this PluginErrorDetails.
        The plugin error reason.


        :param reason: The reason of this PluginErrorDetails.
        :type: str
        """
        allowed_values = ["REGISTRATION_POLICY", "LOG_RESOURCE_POLICY", "NO_FLEET"]
        if not value_allowed_none_or_none_sentinel(reason, allowed_values):
            reason = 'UNKNOWN_ENUM_VALUE'
        self._reason = reason

    @property
    def details(self):
        """
        Gets the details of this PluginErrorDetails.
        Optional string containing additional details.


        :return: The details of this PluginErrorDetails.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this PluginErrorDetails.
        Optional string containing additional details.


        :param details: The details of this PluginErrorDetails.
        :type: str
        """
        self._details = details

    @property
    def time_last_seen(self):
        """
        **[Required]** Gets the time_last_seen of this PluginErrorDetails.
        The date and time the resource was _last_ reported to JMS.
        This is potentially _after_ the specified time period provided by the filters.
        For example, a resource can be last reported to JMS before the start of a specified time period,
        if it is also reported during the time period.


        :return: The time_last_seen of this PluginErrorDetails.
        :rtype: datetime
        """
        return self._time_last_seen

    @time_last_seen.setter
    def time_last_seen(self, time_last_seen):
        """
        Sets the time_last_seen of this PluginErrorDetails.
        The date and time the resource was _last_ reported to JMS.
        This is potentially _after_ the specified time period provided by the filters.
        For example, a resource can be last reported to JMS before the start of a specified time period,
        if it is also reported during the time period.


        :param time_last_seen: The time_last_seen of this PluginErrorDetails.
        :type: datetime
        """
        self._time_last_seen = time_last_seen

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
