# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TaskDetails(object):
    """
    The minimum details of a task.
    """

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "CRYPTO"
    TASK_TYPE_CRYPTO = "CRYPTO"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "JFR"
    TASK_TYPE_JFR = "JFR"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "SCAN_LIBRARY"
    TASK_TYPE_SCAN_LIBRARY = "SCAN_LIBRARY"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "SCAN_JAVA_SERVER"
    TASK_TYPE_SCAN_JAVA_SERVER = "SCAN_JAVA_SERVER"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "JAVA_MIGRATION"
    TASK_TYPE_JAVA_MIGRATION = "JAVA_MIGRATION"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "DEPLOYED_APPLICATION_MIGRATION"
    TASK_TYPE_DEPLOYED_APPLICATION_MIGRATION = "DEPLOYED_APPLICATION_MIGRATION"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "PERFORMANCE_TUNING"
    TASK_TYPE_PERFORMANCE_TUNING = "PERFORMANCE_TUNING"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "ADD_INSTALLATION_SITE"
    TASK_TYPE_ADD_INSTALLATION_SITE = "ADD_INSTALLATION_SITE"

    #: A constant which can be used with the task_type property of a TaskDetails.
    #: This constant has a value of "REMOVE_INSTALLATION_SITE"
    TASK_TYPE_REMOVE_INSTALLATION_SITE = "REMOVE_INSTALLATION_SITE"

    def __init__(self, **kwargs):
        """
        Initializes a new TaskDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.jms.models.DeployedApplicationMigrationTaskDetails`
        * :class:`~oci.jms.models.RemoveInstallationSiteTaskDetails`
        * :class:`~oci.jms.models.CryptoTaskDetails`
        * :class:`~oci.jms.models.JavaMigrationTaskDetails`
        * :class:`~oci.jms.models.ScanLibraryTaskDetails`
        * :class:`~oci.jms.models.PerformanceTuningTaskDetails`
        * :class:`~oci.jms.models.ScanJavaServerTaskDetails`
        * :class:`~oci.jms.models.JfrTaskDetails`
        * :class:`~oci.jms.models.AddInstallationSiteTaskDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param task_type:
            The value to assign to the task_type property of this TaskDetails.
            Allowed values for this property are: "CRYPTO", "JFR", "SCAN_LIBRARY", "SCAN_JAVA_SERVER", "JAVA_MIGRATION", "DEPLOYED_APPLICATION_MIGRATION", "PERFORMANCE_TUNING", "ADD_INSTALLATION_SITE", "REMOVE_INSTALLATION_SITE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type task_type: str

        """
        self.swagger_types = {
            'task_type': 'str'
        }
        self.attribute_map = {
            'task_type': 'taskType'
        }
        self._task_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['taskType']

        if type == 'DEPLOYED_APPLICATION_MIGRATION':
            return 'DeployedApplicationMigrationTaskDetails'

        if type == 'REMOVE_INSTALLATION_SITE':
            return 'RemoveInstallationSiteTaskDetails'

        if type == 'CRYPTO':
            return 'CryptoTaskDetails'

        if type == 'JAVA_MIGRATION':
            return 'JavaMigrationTaskDetails'

        if type == 'SCAN_LIBRARY':
            return 'ScanLibraryTaskDetails'

        if type == 'PERFORMANCE_TUNING':
            return 'PerformanceTuningTaskDetails'

        if type == 'SCAN_JAVA_SERVER':
            return 'ScanJavaServerTaskDetails'

        if type == 'JFR':
            return 'JfrTaskDetails'

        if type == 'ADD_INSTALLATION_SITE':
            return 'AddInstallationSiteTaskDetails'
        else:
            return 'TaskDetails'

    @property
    def task_type(self):
        """
        **[Required]** Gets the task_type of this TaskDetails.
        Type of task.

        Allowed values for this property are: "CRYPTO", "JFR", "SCAN_LIBRARY", "SCAN_JAVA_SERVER", "JAVA_MIGRATION", "DEPLOYED_APPLICATION_MIGRATION", "PERFORMANCE_TUNING", "ADD_INSTALLATION_SITE", "REMOVE_INSTALLATION_SITE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The task_type of this TaskDetails.
        :rtype: str
        """
        return self._task_type

    @task_type.setter
    def task_type(self, task_type):
        """
        Sets the task_type of this TaskDetails.
        Type of task.


        :param task_type: The task_type of this TaskDetails.
        :type: str
        """
        allowed_values = ["CRYPTO", "JFR", "SCAN_LIBRARY", "SCAN_JAVA_SERVER", "JAVA_MIGRATION", "DEPLOYED_APPLICATION_MIGRATION", "PERFORMANCE_TUNING", "ADD_INSTALLATION_SITE", "REMOVE_INSTALLATION_SITE"]
        if not value_allowed_none_or_none_sentinel(task_type, allowed_values):
            task_type = 'UNKNOWN_ENUM_VALUE'
        self._task_type = task_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
