# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DimensionField(object):
    """
    Metric collection dimension field.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DimensionField object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param query_field_name:
            The value to assign to the query_field_name property of this DimensionField.
        :type query_field_name: str

        :param dimension_name:
            The value to assign to the dimension_name property of this DimensionField.
        :type dimension_name: str

        """
        self.swagger_types = {
            'query_field_name': 'str',
            'dimension_name': 'str'
        }
        self.attribute_map = {
            'query_field_name': 'queryFieldName',
            'dimension_name': 'dimensionName'
        }
        self._query_field_name = None
        self._dimension_name = None

    @property
    def query_field_name(self):
        """
        **[Required]** Gets the query_field_name of this DimensionField.
        Output field in the query to be used as the source for the metric dimension.


        :return: The query_field_name of this DimensionField.
        :rtype: str
        """
        return self._query_field_name

    @query_field_name.setter
    def query_field_name(self, query_field_name):
        """
        Sets the query_field_name of this DimensionField.
        Output field in the query to be used as the source for the metric dimension.


        :param query_field_name: The query_field_name of this DimensionField.
        :type: str
        """
        self._query_field_name = query_field_name

    @property
    def dimension_name(self):
        """
        Gets the dimension_name of this DimensionField.
        Dimension name to be stored with the metric.


        :return: The dimension_name of this DimensionField.
        :rtype: str
        """
        return self._dimension_name

    @dimension_name.setter
    def dimension_name(self, dimension_name):
        """
        Sets the dimension_name of this DimensionField.
        Dimension name to be stored with the metric.


        :param dimension_name: The dimension_name of this DimensionField.
        :type: str
        """
        self._dimension_name = dimension_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
