# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LabelSourceSummary(object):
    """
    source summary
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LabelSourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_display_name:
            The value to assign to the source_display_name property of this LabelSourceSummary.
        :type source_display_name: str

        :param source_name:
            The value to assign to the source_name property of this LabelSourceSummary.
        :type source_name: str

        :param source_id:
            The value to assign to the source_id property of this LabelSourceSummary.
        :type source_id: int

        :param label_operator_name:
            The value to assign to the label_operator_name property of this LabelSourceSummary.
        :type label_operator_name: str

        :param label_condition:
            The value to assign to the label_condition property of this LabelSourceSummary.
        :type label_condition: str

        :param condition_string:
            The value to assign to the condition_string property of this LabelSourceSummary.
        :type condition_string: str

        :param condition_block:
            The value to assign to the condition_block property of this LabelSourceSummary.
        :type condition_block: oci.log_analytics.models.ConditionBlock

        :param label_field_displayname:
            The value to assign to the label_field_displayname property of this LabelSourceSummary.
        :type label_field_displayname: str

        :param label_field_name:
            The value to assign to the label_field_name property of this LabelSourceSummary.
        :type label_field_name: str

        """
        self.swagger_types = {
            'source_display_name': 'str',
            'source_name': 'str',
            'source_id': 'int',
            'label_operator_name': 'str',
            'label_condition': 'str',
            'condition_string': 'str',
            'condition_block': 'ConditionBlock',
            'label_field_displayname': 'str',
            'label_field_name': 'str'
        }
        self.attribute_map = {
            'source_display_name': 'sourceDisplayName',
            'source_name': 'sourceName',
            'source_id': 'sourceId',
            'label_operator_name': 'labelOperatorName',
            'label_condition': 'labelCondition',
            'condition_string': 'conditionString',
            'condition_block': 'conditionBlock',
            'label_field_displayname': 'labelFieldDisplayname',
            'label_field_name': 'labelFieldName'
        }
        self._source_display_name = None
        self._source_name = None
        self._source_id = None
        self._label_operator_name = None
        self._label_condition = None
        self._condition_string = None
        self._condition_block = None
        self._label_field_displayname = None
        self._label_field_name = None

    @property
    def source_display_name(self):
        """
        Gets the source_display_name of this LabelSourceSummary.
        The source display name.


        :return: The source_display_name of this LabelSourceSummary.
        :rtype: str
        """
        return self._source_display_name

    @source_display_name.setter
    def source_display_name(self, source_display_name):
        """
        Sets the source_display_name of this LabelSourceSummary.
        The source display name.


        :param source_display_name: The source_display_name of this LabelSourceSummary.
        :type: str
        """
        self._source_display_name = source_display_name

    @property
    def source_name(self):
        """
        Gets the source_name of this LabelSourceSummary.
        The source internal name.


        :return: The source_name of this LabelSourceSummary.
        :rtype: str
        """
        return self._source_name

    @source_name.setter
    def source_name(self, source_name):
        """
        Sets the source_name of this LabelSourceSummary.
        The source internal name.


        :param source_name: The source_name of this LabelSourceSummary.
        :type: str
        """
        self._source_name = source_name

    @property
    def source_id(self):
        """
        Gets the source_id of this LabelSourceSummary.
        The source unique identifier.


        :return: The source_id of this LabelSourceSummary.
        :rtype: int
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id):
        """
        Sets the source_id of this LabelSourceSummary.
        The source unique identifier.


        :param source_id: The source_id of this LabelSourceSummary.
        :type: int
        """
        self._source_id = source_id

    @property
    def label_operator_name(self):
        """
        Gets the label_operator_name of this LabelSourceSummary.
        The label operator.


        :return: The label_operator_name of this LabelSourceSummary.
        :rtype: str
        """
        return self._label_operator_name

    @label_operator_name.setter
    def label_operator_name(self, label_operator_name):
        """
        Sets the label_operator_name of this LabelSourceSummary.
        The label operator.


        :param label_operator_name: The label_operator_name of this LabelSourceSummary.
        :type: str
        """
        self._label_operator_name = label_operator_name

    @property
    def label_condition(self):
        """
        Gets the label_condition of this LabelSourceSummary.
        The label condition.


        :return: The label_condition of this LabelSourceSummary.
        :rtype: str
        """
        return self._label_condition

    @label_condition.setter
    def label_condition(self, label_condition):
        """
        Sets the label_condition of this LabelSourceSummary.
        The label condition.


        :param label_condition: The label_condition of this LabelSourceSummary.
        :type: str
        """
        self._label_condition = label_condition

    @property
    def condition_string(self):
        """
        Gets the condition_string of this LabelSourceSummary.
        String representation of the label condition.


        :return: The condition_string of this LabelSourceSummary.
        :rtype: str
        """
        return self._condition_string

    @condition_string.setter
    def condition_string(self, condition_string):
        """
        Sets the condition_string of this LabelSourceSummary.
        String representation of the label condition.


        :param condition_string: The condition_string of this LabelSourceSummary.
        :type: str
        """
        self._condition_string = condition_string

    @property
    def condition_block(self):
        """
        Gets the condition_block of this LabelSourceSummary.

        :return: The condition_block of this LabelSourceSummary.
        :rtype: oci.log_analytics.models.ConditionBlock
        """
        return self._condition_block

    @condition_block.setter
    def condition_block(self, condition_block):
        """
        Sets the condition_block of this LabelSourceSummary.

        :param condition_block: The condition_block of this LabelSourceSummary.
        :type: oci.log_analytics.models.ConditionBlock
        """
        self._condition_block = condition_block

    @property
    def label_field_displayname(self):
        """
        Gets the label_field_displayname of this LabelSourceSummary.
        The label field display name.


        :return: The label_field_displayname of this LabelSourceSummary.
        :rtype: str
        """
        return self._label_field_displayname

    @label_field_displayname.setter
    def label_field_displayname(self, label_field_displayname):
        """
        Sets the label_field_displayname of this LabelSourceSummary.
        The label field display name.


        :param label_field_displayname: The label_field_displayname of this LabelSourceSummary.
        :type: str
        """
        self._label_field_displayname = label_field_displayname

    @property
    def label_field_name(self):
        """
        Gets the label_field_name of this LabelSourceSummary.
        The label field name.


        :return: The label_field_name of this LabelSourceSummary.
        :rtype: str
        """
        return self._label_field_name

    @label_field_name.setter
    def label_field_name(self, label_field_name):
        """
        Sets the label_field_name of this LabelSourceSummary.
        The label field name.


        :param label_field_name: The label_field_name of this LabelSourceSummary.
        :type: str
        """
        self._label_field_name = label_field_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
