# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TemplateDetails(object):
    """
    details for scheduled task using template
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TemplateDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param template_id:
            The value to assign to the template_id property of this TemplateDetails.
        :type template_id: str

        :param template_params:
            The value to assign to the template_params property of this TemplateDetails.
        :type template_params: list[oci.log_analytics.models.TemplateParams]

        """
        self.swagger_types = {
            'template_id': 'str',
            'template_params': 'list[TemplateParams]'
        }
        self.attribute_map = {
            'template_id': 'templateId',
            'template_params': 'templateParams'
        }
        self._template_id = None
        self._template_params = None

    @property
    def template_id(self):
        """
        **[Required]** Gets the template_id of this TemplateDetails.
        The Config template Id of a particular template.


        :return: The template_id of this TemplateDetails.
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """
        Sets the template_id of this TemplateDetails.
        The Config template Id of a particular template.


        :param template_id: The template_id of this TemplateDetails.
        :type: str
        """
        self._template_id = template_id

    @property
    def template_params(self):
        """
        Gets the template_params of this TemplateDetails.
        To store macro params.


        :return: The template_params of this TemplateDetails.
        :rtype: list[oci.log_analytics.models.TemplateParams]
        """
        return self._template_params

    @template_params.setter
    def template_params(self, template_params):
        """
        Sets the template_params of this TemplateDetails.
        To store macro params.


        :param template_params: The template_params of this TemplateDetails.
        :type: list[oci.log_analytics.models.TemplateParams]
        """
        self._template_params = template_params

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
