# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdditionalInfo(object):
    """
    Additional information about the lead
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdditionalInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param company:
            The value to assign to the company property of this AdditionalInfo.
        :type company: str

        :param company_address:
            The value to assign to the company_address property of this AdditionalInfo.
        :type company_address: str

        :param email:
            The value to assign to the email property of this AdditionalInfo.
        :type email: str

        :param first_name:
            The value to assign to the first_name property of this AdditionalInfo.
        :type first_name: str

        :param last_name:
            The value to assign to the last_name property of this AdditionalInfo.
        :type last_name: str

        :param phone:
            The value to assign to the phone property of this AdditionalInfo.
        :type phone: str

        :param notes:
            The value to assign to the notes property of this AdditionalInfo.
        :type notes: str

        """
        self.swagger_types = {
            'company': 'str',
            'company_address': 'str',
            'email': 'str',
            'first_name': 'str',
            'last_name': 'str',
            'phone': 'str',
            'notes': 'str'
        }
        self.attribute_map = {
            'company': 'company',
            'company_address': 'companyAddress',
            'email': 'email',
            'first_name': 'firstName',
            'last_name': 'lastName',
            'phone': 'phone',
            'notes': 'notes'
        }
        self._company = None
        self._company_address = None
        self._email = None
        self._first_name = None
        self._last_name = None
        self._phone = None
        self._notes = None

    @property
    def company(self):
        """
        Gets the company of this AdditionalInfo.
        The company name


        :return: The company of this AdditionalInfo.
        :rtype: str
        """
        return self._company

    @company.setter
    def company(self, company):
        """
        Sets the company of this AdditionalInfo.
        The company name


        :param company: The company of this AdditionalInfo.
        :type: str
        """
        self._company = company

    @property
    def company_address(self):
        """
        Gets the company_address of this AdditionalInfo.
        The company address


        :return: The company_address of this AdditionalInfo.
        :rtype: str
        """
        return self._company_address

    @company_address.setter
    def company_address(self, company_address):
        """
        Sets the company_address of this AdditionalInfo.
        The company address


        :param company_address: The company_address of this AdditionalInfo.
        :type: str
        """
        self._company_address = company_address

    @property
    def email(self):
        """
        Gets the email of this AdditionalInfo.
        The email address


        :return: The email of this AdditionalInfo.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this AdditionalInfo.
        The email address


        :param email: The email of this AdditionalInfo.
        :type: str
        """
        self._email = email

    @property
    def first_name(self):
        """
        Gets the first_name of this AdditionalInfo.
        The first name


        :return: The first_name of this AdditionalInfo.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this AdditionalInfo.
        The first name


        :param first_name: The first_name of this AdditionalInfo.
        :type: str
        """
        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this AdditionalInfo.
        The last name


        :return: The last_name of this AdditionalInfo.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this AdditionalInfo.
        The last name


        :param last_name: The last_name of this AdditionalInfo.
        :type: str
        """
        self._last_name = last_name

    @property
    def phone(self):
        """
        Gets the phone of this AdditionalInfo.
        The phone number


        :return: The phone of this AdditionalInfo.
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """
        Sets the phone of this AdditionalInfo.
        The phone number


        :param phone: The phone of this AdditionalInfo.
        :type: str
        """
        self._phone = phone

    @property
    def notes(self):
        """
        Gets the notes of this AdditionalInfo.
        Additional notes


        :return: The notes of this AdditionalInfo.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this AdditionalInfo.
        Additional notes


        :param notes: The notes of this AdditionalInfo.
        :type: str
        """
        self._notes = notes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
