# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .create_listing_revision_attachment_details import CreateListingRevisionAttachmentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCustomerSuccessAttachment(CreateListingRevisionAttachmentDetails):
    """
    customer success story attachment for the listing revision.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCustomerSuccessAttachment object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.CreateCustomerSuccessAttachment.attachment_type` attribute
        of this class is ``CUSTOMER_SUCCESS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param listing_revision_id:
            The value to assign to the listing_revision_id property of this CreateCustomerSuccessAttachment.
        :type listing_revision_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateCustomerSuccessAttachment.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateCustomerSuccessAttachment.
        :type description: str

        :param attachment_type:
            The value to assign to the attachment_type property of this CreateCustomerSuccessAttachment.
        :type attachment_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCustomerSuccessAttachment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCustomerSuccessAttachment.
        :type defined_tags: dict(str, dict(str, object))

        :param customer_name:
            The value to assign to the customer_name property of this CreateCustomerSuccessAttachment.
        :type customer_name: str

        :param url:
            The value to assign to the url property of this CreateCustomerSuccessAttachment.
        :type url: str

        :param product_codes:
            The value to assign to the product_codes property of this CreateCustomerSuccessAttachment.
        :type product_codes: list[str]

        """
        self.swagger_types = {
            'listing_revision_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'attachment_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'customer_name': 'str',
            'url': 'str',
            'product_codes': 'list[str]'
        }
        self.attribute_map = {
            'listing_revision_id': 'listingRevisionId',
            'display_name': 'displayName',
            'description': 'description',
            'attachment_type': 'attachmentType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'customer_name': 'customerName',
            'url': 'url',
            'product_codes': 'productCodes'
        }
        self._listing_revision_id = None
        self._display_name = None
        self._description = None
        self._attachment_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._customer_name = None
        self._url = None
        self._product_codes = None
        self._attachment_type = 'CUSTOMER_SUCCESS'

    @property
    def customer_name(self):
        """
        **[Required]** Gets the customer_name of this CreateCustomerSuccessAttachment.
        Name of the customer


        :return: The customer_name of this CreateCustomerSuccessAttachment.
        :rtype: str
        """
        return self._customer_name

    @customer_name.setter
    def customer_name(self, customer_name):
        """
        Sets the customer_name of this CreateCustomerSuccessAttachment.
        Name of the customer


        :param customer_name: The customer_name of this CreateCustomerSuccessAttachment.
        :type: str
        """
        self._customer_name = customer_name

    @property
    def url(self):
        """
        Gets the url of this CreateCustomerSuccessAttachment.
        Optional url to success story


        :return: The url of this CreateCustomerSuccessAttachment.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this CreateCustomerSuccessAttachment.
        Optional url to success story


        :param url: The url of this CreateCustomerSuccessAttachment.
        :type: str
        """
        self._url = url

    @property
    def product_codes(self):
        """
        Gets the product_codes of this CreateCustomerSuccessAttachment.
        List of product codes for success story


        :return: The product_codes of this CreateCustomerSuccessAttachment.
        :rtype: list[str]
        """
        return self._product_codes

    @product_codes.setter
    def product_codes(self, product_codes):
        """
        Sets the product_codes of this CreateCustomerSuccessAttachment.
        List of product codes for success story


        :param product_codes: The product_codes of this CreateCustomerSuccessAttachment.
        :type: list[str]
        """
        self._product_codes = product_codes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
