# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateListingDetails(object):
    """
    Details to create a new listing.
    """

    #: A constant which can be used with the listing_type property of a CreateListingDetails.
    #: This constant has a value of "OCI_APPLICATION"
    LISTING_TYPE_OCI_APPLICATION = "OCI_APPLICATION"

    #: A constant which can be used with the listing_type property of a CreateListingDetails.
    #: This constant has a value of "LEAD_GENERATION"
    LISTING_TYPE_LEAD_GENERATION = "LEAD_GENERATION"

    #: A constant which can be used with the listing_type property of a CreateListingDetails.
    #: This constant has a value of "SERVICE"
    LISTING_TYPE_SERVICE = "SERVICE"

    #: A constant which can be used with the package_type property of a CreateListingDetails.
    #: This constant has a value of "CONTAINER_IMAGE"
    PACKAGE_TYPE_CONTAINER_IMAGE = "CONTAINER_IMAGE"

    #: A constant which can be used with the package_type property of a CreateListingDetails.
    #: This constant has a value of "HELM_CHART"
    PACKAGE_TYPE_HELM_CHART = "HELM_CHART"

    #: A constant which can be used with the package_type property of a CreateListingDetails.
    #: This constant has a value of "MACHINE_IMAGE"
    PACKAGE_TYPE_MACHINE_IMAGE = "MACHINE_IMAGE"

    #: A constant which can be used with the package_type property of a CreateListingDetails.
    #: This constant has a value of "STACK"
    PACKAGE_TYPE_STACK = "STACK"

    #: A constant which can be used with the package_type property of a CreateListingDetails.
    #: This constant has a value of "NONE"
    PACKAGE_TYPE_NONE = "NONE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateListingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateListingDetails.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CreateListingDetails.
        :type name: str

        :param listing_type:
            The value to assign to the listing_type property of this CreateListingDetails.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"
        :type listing_type: str

        :param package_type:
            The value to assign to the package_type property of this CreateListingDetails.
            Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE"
        :type package_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateListingDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateListingDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'name': 'str',
            'listing_type': 'str',
            'package_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'name': 'name',
            'listing_type': 'listingType',
            'package_type': 'packageType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._name = None
        self._listing_type = None
        self._package_type = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateListingDetails.
        The unique identifier for the compartment.


        :return: The compartment_id of this CreateListingDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateListingDetails.
        The unique identifier for the compartment.


        :param compartment_id: The compartment_id of this CreateListingDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateListingDetails.
        The name for the listing.


        :return: The name of this CreateListingDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateListingDetails.
        The name for the listing.


        :param name: The name of this CreateListingDetails.
        :type: str
        """
        self._name = name

    @property
    def listing_type(self):
        """
        **[Required]** Gets the listing_type of this CreateListingDetails.
        The listing type for the listing.

        Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"


        :return: The listing_type of this CreateListingDetails.
        :rtype: str
        """
        return self._listing_type

    @listing_type.setter
    def listing_type(self, listing_type):
        """
        Sets the listing_type of this CreateListingDetails.
        The listing type for the listing.


        :param listing_type: The listing_type of this CreateListingDetails.
        :type: str
        """
        allowed_values = ["OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"]
        if not value_allowed_none_or_none_sentinel(listing_type, allowed_values):
            raise ValueError(
                f"Invalid value for `listing_type`, must be None or one of {allowed_values}"
            )
        self._listing_type = listing_type

    @property
    def package_type(self):
        """
        **[Required]** Gets the package_type of this CreateListingDetails.
        The package type for the listing.

        Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE"


        :return: The package_type of this CreateListingDetails.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this CreateListingDetails.
        The package type for the listing.


        :param package_type: The package_type of this CreateListingDetails.
        :type: str
        """
        allowed_values = ["CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE"]
        if not value_allowed_none_or_none_sentinel(package_type, allowed_values):
            raise ValueError(
                f"Invalid value for `package_type`, must be None or one of {allowed_values}"
            )
        self._package_type = package_type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateListingDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateListingDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateListingDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateListingDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateListingDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateListingDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateListingDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateListingDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
