# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from .cloud_service_provider_metadata_item import CloudServiceProviderMetadataItem
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GcpCloudServiceProviderMetadataItem(CloudServiceProviderMetadataItem):
    """
    GCP Cloud Service Provider metadata item.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GcpCloudServiceProviderMetadataItem object with values from keyword arguments. The default value of the :py:attr:`~oci.multicloud.models.GcpCloudServiceProviderMetadataItem.subscription_type` attribute
        of this class is ``ORACLEDBATGOOGLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region:
            The value to assign to the region property of this GcpCloudServiceProviderMetadataItem.
        :type region: str

        :param resource_anchor_name:
            The value to assign to the resource_anchor_name property of this GcpCloudServiceProviderMetadataItem.
        :type resource_anchor_name: str

        :param csp_resource_anchor_id:
            The value to assign to the csp_resource_anchor_id property of this GcpCloudServiceProviderMetadataItem.
        :type csp_resource_anchor_id: str

        :param csp_resource_anchor_name:
            The value to assign to the csp_resource_anchor_name property of this GcpCloudServiceProviderMetadataItem.
        :type csp_resource_anchor_name: str

        :param resource_anchor_uri:
            The value to assign to the resource_anchor_uri property of this GcpCloudServiceProviderMetadataItem.
        :type resource_anchor_uri: str

        :param csp_additional_properties:
            The value to assign to the csp_additional_properties property of this GcpCloudServiceProviderMetadataItem.
        :type csp_additional_properties: dict(str, str)

        :param subscription_type:
            The value to assign to the subscription_type property of this GcpCloudServiceProviderMetadataItem.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"
        :type subscription_type: str

        :param project_number:
            The value to assign to the project_number property of this GcpCloudServiceProviderMetadataItem.
        :type project_number: str

        """
        self.swagger_types = {
            'region': 'str',
            'resource_anchor_name': 'str',
            'csp_resource_anchor_id': 'str',
            'csp_resource_anchor_name': 'str',
            'resource_anchor_uri': 'str',
            'csp_additional_properties': 'dict(str, str)',
            'subscription_type': 'str',
            'project_number': 'str'
        }
        self.attribute_map = {
            'region': 'region',
            'resource_anchor_name': 'resourceAnchorName',
            'csp_resource_anchor_id': 'cspResourceAnchorId',
            'csp_resource_anchor_name': 'cspResourceAnchorName',
            'resource_anchor_uri': 'resourceAnchorUri',
            'csp_additional_properties': 'cspAdditionalProperties',
            'subscription_type': 'subscriptionType',
            'project_number': 'projectNumber'
        }
        self._region = None
        self._resource_anchor_name = None
        self._csp_resource_anchor_id = None
        self._csp_resource_anchor_name = None
        self._resource_anchor_uri = None
        self._csp_additional_properties = None
        self._subscription_type = None
        self._project_number = None
        self._subscription_type = 'ORACLEDBATGOOGLE'

    @property
    def project_number(self):
        """
        **[Required]** Gets the project_number of this GcpCloudServiceProviderMetadataItem.
        GCP project number that was used for creating this resource anchor resource.


        :return: The project_number of this GcpCloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._project_number

    @project_number.setter
    def project_number(self, project_number):
        """
        Sets the project_number of this GcpCloudServiceProviderMetadataItem.
        GCP project number that was used for creating this resource anchor resource.


        :param project_number: The project_number of this GcpCloudServiceProviderMetadataItem.
        :type: str
        """
        self._project_number = project_number

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
