# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CompressionOptions(object):
    """
    The additional compression options used while exporting the DB system backup.
    """

    #: A constant which can be used with the type property of a CompressionOptions.
    #: This constant has a value of "GZIP"
    TYPE_GZIP = "GZIP"

    #: A constant which can be used with the type property of a CompressionOptions.
    #: This constant has a value of "ZSTD"
    TYPE_ZSTD = "ZSTD"

    def __init__(self, **kwargs):
        """
        Initializes a new CompressionOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_enabled:
            The value to assign to the is_enabled property of this CompressionOptions.
        :type is_enabled: bool

        :param level:
            The value to assign to the level property of this CompressionOptions.
        :type level: int

        :param type:
            The value to assign to the type property of this CompressionOptions.
            Allowed values for this property are: "GZIP", "ZSTD"
        :type type: str

        """
        self.swagger_types = {
            'is_enabled': 'bool',
            'level': 'int',
            'type': 'str'
        }
        self.attribute_map = {
            'is_enabled': 'isEnabled',
            'level': 'level',
            'type': 'type'
        }
        self._is_enabled = None
        self._level = None
        self._type = None

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this CompressionOptions.
        The compression status of the exported data.


        :return: The is_enabled of this CompressionOptions.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this CompressionOptions.
        The compression status of the exported data.


        :param is_enabled: The is_enabled of this CompressionOptions.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def level(self):
        """
        Gets the level of this CompressionOptions.
        The level of compression to use when creating the dump files.


        :return: The level of this CompressionOptions.
        :rtype: int
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this CompressionOptions.
        The level of compression to use when creating the dump files.


        :param level: The level of this CompressionOptions.
        :type: int
        """
        self._level = level

    @property
    def type(self):
        """
        Gets the type of this CompressionOptions.
        The compression type to use when creating the dump files.

        Allowed values for this property are: "GZIP", "ZSTD"


        :return: The type of this CompressionOptions.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CompressionOptions.
        The compression type to use when creating the dump files.


        :param type: The type of this CompressionOptions.
        :type: str
        """
        allowed_values = ["GZIP", "ZSTD"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
