# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemSummary(object):
    """
    A summary of a DB System.
    """

    #: A constant which can be used with the crash_recovery property of a DbSystemSummary.
    #: This constant has a value of "ENABLED"
    CRASH_RECOVERY_ENABLED = "ENABLED"

    #: A constant which can be used with the crash_recovery property of a DbSystemSummary.
    #: This constant has a value of "DISABLED"
    CRASH_RECOVERY_DISABLED = "DISABLED"

    #: A constant which can be used with the database_management property of a DbSystemSummary.
    #: This constant has a value of "ENABLED"
    DATABASE_MANAGEMENT_ENABLED = "ENABLED"

    #: A constant which can be used with the database_management property of a DbSystemSummary.
    #: This constant has a value of "DISABLED"
    DATABASE_MANAGEMENT_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DbSystemSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DbSystemSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DbSystemSummary.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DbSystemSummary.
        :type compartment_id: str

        :param rest:
            The value to assign to the rest property of this DbSystemSummary.
        :type rest: oci.mysql.models.RestDetails

        :param database_console:
            The value to assign to the database_console property of this DbSystemSummary.
        :type database_console: oci.mysql.models.DatabaseConsoleDetails

        :param is_highly_available:
            The value to assign to the is_highly_available property of this DbSystemSummary.
        :type is_highly_available: bool

        :param current_placement:
            The value to assign to the current_placement property of this DbSystemSummary.
        :type current_placement: oci.mysql.models.DbSystemPlacement

        :param is_heat_wave_cluster_attached:
            The value to assign to the is_heat_wave_cluster_attached property of this DbSystemSummary.
        :type is_heat_wave_cluster_attached: bool

        :param heat_wave_cluster:
            The value to assign to the heat_wave_cluster property of this DbSystemSummary.
        :type heat_wave_cluster: oci.mysql.models.HeatWaveClusterSummary

        :param availability_domain:
            The value to assign to the availability_domain property of this DbSystemSummary.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this DbSystemSummary.
        :type fault_domain: str

        :param endpoints:
            The value to assign to the endpoints property of this DbSystemSummary.
        :type endpoints: list[oci.mysql.models.DbSystemEndpoint]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DbSystemSummary.
        :type lifecycle_state: str

        :param mysql_version:
            The value to assign to the mysql_version property of this DbSystemSummary.
        :type mysql_version: str

        :param time_created:
            The value to assign to the time_created property of this DbSystemSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DbSystemSummary.
        :type time_updated: datetime

        :param deletion_policy:
            The value to assign to the deletion_policy property of this DbSystemSummary.
        :type deletion_policy: oci.mysql.models.DeletionPolicyDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DbSystemSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DbSystemSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DbSystemSummary.
        :type system_tags: dict(str, dict(str, object))

        :param backup_policy:
            The value to assign to the backup_policy property of this DbSystemSummary.
        :type backup_policy: oci.mysql.models.BackupPolicy

        :param shape_name:
            The value to assign to the shape_name property of this DbSystemSummary.
        :type shape_name: str

        :param crash_recovery:
            The value to assign to the crash_recovery property of this DbSystemSummary.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type crash_recovery: str

        :param database_management:
            The value to assign to the database_management property of this DbSystemSummary.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_management: str

        :param database_mode:
            The value to assign to the database_mode property of this DbSystemSummary.
        :type database_mode: str

        :param access_mode:
            The value to assign to the access_mode property of this DbSystemSummary.
        :type access_mode: str

        :param read_endpoint:
            The value to assign to the read_endpoint property of this DbSystemSummary.
        :type read_endpoint: oci.mysql.models.ReadEndpointDetails

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'rest': 'RestDetails',
            'database_console': 'DatabaseConsoleDetails',
            'is_highly_available': 'bool',
            'current_placement': 'DbSystemPlacement',
            'is_heat_wave_cluster_attached': 'bool',
            'heat_wave_cluster': 'HeatWaveClusterSummary',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'endpoints': 'list[DbSystemEndpoint]',
            'lifecycle_state': 'str',
            'mysql_version': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'deletion_policy': 'DeletionPolicyDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'backup_policy': 'BackupPolicy',
            'shape_name': 'str',
            'crash_recovery': 'str',
            'database_management': 'str',
            'database_mode': 'str',
            'access_mode': 'str',
            'read_endpoint': 'ReadEndpointDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'rest': 'rest',
            'database_console': 'databaseConsole',
            'is_highly_available': 'isHighlyAvailable',
            'current_placement': 'currentPlacement',
            'is_heat_wave_cluster_attached': 'isHeatWaveClusterAttached',
            'heat_wave_cluster': 'heatWaveCluster',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'endpoints': 'endpoints',
            'lifecycle_state': 'lifecycleState',
            'mysql_version': 'mysqlVersion',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'deletion_policy': 'deletionPolicy',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'backup_policy': 'backupPolicy',
            'shape_name': 'shapeName',
            'crash_recovery': 'crashRecovery',
            'database_management': 'databaseManagement',
            'database_mode': 'databaseMode',
            'access_mode': 'accessMode',
            'read_endpoint': 'readEndpoint'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._rest = None
        self._database_console = None
        self._is_highly_available = None
        self._current_placement = None
        self._is_heat_wave_cluster_attached = None
        self._heat_wave_cluster = None
        self._availability_domain = None
        self._fault_domain = None
        self._endpoints = None
        self._lifecycle_state = None
        self._mysql_version = None
        self._time_created = None
        self._time_updated = None
        self._deletion_policy = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._backup_policy = None
        self._shape_name = None
        self._crash_recovery = None
        self._database_management = None
        self._database_mode = None
        self._access_mode = None
        self._read_endpoint = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbSystemSummary.
        The OCID of the DB System.


        :return: The id of this DbSystemSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbSystemSummary.
        The OCID of the DB System.


        :param id: The id of this DbSystemSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DbSystemSummary.
        The user-friendly name for the DB System. It does not have to be unique.


        :return: The display_name of this DbSystemSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DbSystemSummary.
        The user-friendly name for the DB System. It does not have to be unique.


        :param display_name: The display_name of this DbSystemSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DbSystemSummary.
        User-provided data about the DB System.


        :return: The description of this DbSystemSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DbSystemSummary.
        User-provided data about the DB System.


        :param description: The description of this DbSystemSummary.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this DbSystemSummary.
        The OCID of the compartment the DB System belongs in.


        :return: The compartment_id of this DbSystemSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DbSystemSummary.
        The OCID of the compartment the DB System belongs in.


        :param compartment_id: The compartment_id of this DbSystemSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def rest(self):
        """
        Gets the rest of this DbSystemSummary.

        :return: The rest of this DbSystemSummary.
        :rtype: oci.mysql.models.RestDetails
        """
        return self._rest

    @rest.setter
    def rest(self, rest):
        """
        Sets the rest of this DbSystemSummary.

        :param rest: The rest of this DbSystemSummary.
        :type: oci.mysql.models.RestDetails
        """
        self._rest = rest

    @property
    def database_console(self):
        """
        Gets the database_console of this DbSystemSummary.

        :return: The database_console of this DbSystemSummary.
        :rtype: oci.mysql.models.DatabaseConsoleDetails
        """
        return self._database_console

    @database_console.setter
    def database_console(self, database_console):
        """
        Sets the database_console of this DbSystemSummary.

        :param database_console: The database_console of this DbSystemSummary.
        :type: oci.mysql.models.DatabaseConsoleDetails
        """
        self._database_console = database_console

    @property
    def is_highly_available(self):
        """
        Gets the is_highly_available of this DbSystemSummary.
        Specifies if the DB System is highly available.


        :return: The is_highly_available of this DbSystemSummary.
        :rtype: bool
        """
        return self._is_highly_available

    @is_highly_available.setter
    def is_highly_available(self, is_highly_available):
        """
        Sets the is_highly_available of this DbSystemSummary.
        Specifies if the DB System is highly available.


        :param is_highly_available: The is_highly_available of this DbSystemSummary.
        :type: bool
        """
        self._is_highly_available = is_highly_available

    @property
    def current_placement(self):
        """
        Gets the current_placement of this DbSystemSummary.

        :return: The current_placement of this DbSystemSummary.
        :rtype: oci.mysql.models.DbSystemPlacement
        """
        return self._current_placement

    @current_placement.setter
    def current_placement(self, current_placement):
        """
        Sets the current_placement of this DbSystemSummary.

        :param current_placement: The current_placement of this DbSystemSummary.
        :type: oci.mysql.models.DbSystemPlacement
        """
        self._current_placement = current_placement

    @property
    def is_heat_wave_cluster_attached(self):
        """
        Gets the is_heat_wave_cluster_attached of this DbSystemSummary.
        If the DB System has a HeatWave Cluster attached.


        :return: The is_heat_wave_cluster_attached of this DbSystemSummary.
        :rtype: bool
        """
        return self._is_heat_wave_cluster_attached

    @is_heat_wave_cluster_attached.setter
    def is_heat_wave_cluster_attached(self, is_heat_wave_cluster_attached):
        """
        Sets the is_heat_wave_cluster_attached of this DbSystemSummary.
        If the DB System has a HeatWave Cluster attached.


        :param is_heat_wave_cluster_attached: The is_heat_wave_cluster_attached of this DbSystemSummary.
        :type: bool
        """
        self._is_heat_wave_cluster_attached = is_heat_wave_cluster_attached

    @property
    def heat_wave_cluster(self):
        """
        Gets the heat_wave_cluster of this DbSystemSummary.

        :return: The heat_wave_cluster of this DbSystemSummary.
        :rtype: oci.mysql.models.HeatWaveClusterSummary
        """
        return self._heat_wave_cluster

    @heat_wave_cluster.setter
    def heat_wave_cluster(self, heat_wave_cluster):
        """
        Sets the heat_wave_cluster of this DbSystemSummary.

        :param heat_wave_cluster: The heat_wave_cluster of this DbSystemSummary.
        :type: oci.mysql.models.HeatWaveClusterSummary
        """
        self._heat_wave_cluster = heat_wave_cluster

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this DbSystemSummary.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :return: The availability_domain of this DbSystemSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this DbSystemSummary.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :param availability_domain: The availability_domain of this DbSystemSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this DbSystemSummary.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :return: The fault_domain of this DbSystemSummary.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this DbSystemSummary.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :param fault_domain: The fault_domain of this DbSystemSummary.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def endpoints(self):
        """
        Gets the endpoints of this DbSystemSummary.
        The network endpoints available for this DB System.


        :return: The endpoints of this DbSystemSummary.
        :rtype: list[oci.mysql.models.DbSystemEndpoint]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """
        Sets the endpoints of this DbSystemSummary.
        The network endpoints available for this DB System.


        :param endpoints: The endpoints of this DbSystemSummary.
        :type: list[oci.mysql.models.DbSystemEndpoint]
        """
        self._endpoints = endpoints

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DbSystemSummary.
        The current state of the DB System.


        :return: The lifecycle_state of this DbSystemSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DbSystemSummary.
        The current state of the DB System.


        :param lifecycle_state: The lifecycle_state of this DbSystemSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def mysql_version(self):
        """
        **[Required]** Gets the mysql_version of this DbSystemSummary.
        Name of the MySQL Version in use for the DB System.


        :return: The mysql_version of this DbSystemSummary.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this DbSystemSummary.
        Name of the MySQL Version in use for the DB System.


        :param mysql_version: The mysql_version of this DbSystemSummary.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DbSystemSummary.
        The date and time the DB System was created.


        :return: The time_created of this DbSystemSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbSystemSummary.
        The date and time the DB System was created.


        :param time_created: The time_created of this DbSystemSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DbSystemSummary.
        The time the DB System was last updated.


        :return: The time_updated of this DbSystemSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DbSystemSummary.
        The time the DB System was last updated.


        :param time_updated: The time_updated of this DbSystemSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def deletion_policy(self):
        """
        Gets the deletion_policy of this DbSystemSummary.

        :return: The deletion_policy of this DbSystemSummary.
        :rtype: oci.mysql.models.DeletionPolicyDetails
        """
        return self._deletion_policy

    @deletion_policy.setter
    def deletion_policy(self, deletion_policy):
        """
        Sets the deletion_policy of this DbSystemSummary.

        :param deletion_policy: The deletion_policy of this DbSystemSummary.
        :type: oci.mysql.models.DeletionPolicyDetails
        """
        self._deletion_policy = deletion_policy

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DbSystemSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DbSystemSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DbSystemSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DbSystemSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DbSystemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DbSystemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DbSystemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DbSystemSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DbSystemSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DbSystemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DbSystemSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DbSystemSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def backup_policy(self):
        """
        Gets the backup_policy of this DbSystemSummary.

        :return: The backup_policy of this DbSystemSummary.
        :rtype: oci.mysql.models.BackupPolicy
        """
        return self._backup_policy

    @backup_policy.setter
    def backup_policy(self, backup_policy):
        """
        Sets the backup_policy of this DbSystemSummary.

        :param backup_policy: The backup_policy of this DbSystemSummary.
        :type: oci.mysql.models.BackupPolicy
        """
        self._backup_policy = backup_policy

    @property
    def shape_name(self):
        """
        Gets the shape_name of this DbSystemSummary.
        The shape of the primary instances of the DB System. The shape
        determines resources allocated to a DB System - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM
        (or bare metal) shapes. To get a list of shapes, use (the
        :func:`list_shapes` operation.


        :return: The shape_name of this DbSystemSummary.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this DbSystemSummary.
        The shape of the primary instances of the DB System. The shape
        determines resources allocated to a DB System - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM
        (or bare metal) shapes. To get a list of shapes, use (the
        :func:`list_shapes` operation.


        :param shape_name: The shape_name of this DbSystemSummary.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def crash_recovery(self):
        """
        Gets the crash_recovery of this DbSystemSummary.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The crash_recovery of this DbSystemSummary.
        :rtype: str
        """
        return self._crash_recovery

    @crash_recovery.setter
    def crash_recovery(self, crash_recovery):
        """
        Sets the crash_recovery of this DbSystemSummary.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.


        :param crash_recovery: The crash_recovery of this DbSystemSummary.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(crash_recovery, allowed_values):
            crash_recovery = 'UNKNOWN_ENUM_VALUE'
        self._crash_recovery = crash_recovery

    @property
    def database_management(self):
        """
        Gets the database_management of this DbSystemSummary.
        Whether to enable monitoring via the Database Management service.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_management of this DbSystemSummary.
        :rtype: str
        """
        return self._database_management

    @database_management.setter
    def database_management(self, database_management):
        """
        Sets the database_management of this DbSystemSummary.
        Whether to enable monitoring via the Database Management service.


        :param database_management: The database_management of this DbSystemSummary.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(database_management, allowed_values):
            database_management = 'UNKNOWN_ENUM_VALUE'
        self._database_management = database_management

    @property
    def database_mode(self):
        """
        **[Required]** Gets the database_mode of this DbSystemSummary.
        The database mode indicating the types of statements that are allowed to run in the DB system.
        This mode applies only to statements run by user connections. Replicated write statements continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE: allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.


        :return: The database_mode of this DbSystemSummary.
        :rtype: str
        """
        return self._database_mode

    @database_mode.setter
    def database_mode(self, database_mode):
        """
        Sets the database_mode of this DbSystemSummary.
        The database mode indicating the types of statements that are allowed to run in the DB system.
        This mode applies only to statements run by user connections. Replicated write statements continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE: allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.


        :param database_mode: The database_mode of this DbSystemSummary.
        :type: str
        """
        self._database_mode = database_mode

    @property
    def access_mode(self):
        """
        **[Required]** Gets the access_mode of this DbSystemSummary.
        The access mode indicating if the database access is unrestricted (to all MySQL user accounts),
        or restricted (to only certain users with specific privileges):
         - UNRESTRICTED: the access to the database is not restricted;
         - RESTRICTED: the access is allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :return: The access_mode of this DbSystemSummary.
        :rtype: str
        """
        return self._access_mode

    @access_mode.setter
    def access_mode(self, access_mode):
        """
        Sets the access_mode of this DbSystemSummary.
        The access mode indicating if the database access is unrestricted (to all MySQL user accounts),
        or restricted (to only certain users with specific privileges):
         - UNRESTRICTED: the access to the database is not restricted;
         - RESTRICTED: the access is allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :param access_mode: The access_mode of this DbSystemSummary.
        :type: str
        """
        self._access_mode = access_mode

    @property
    def read_endpoint(self):
        """
        Gets the read_endpoint of this DbSystemSummary.

        :return: The read_endpoint of this DbSystemSummary.
        :rtype: oci.mysql.models.ReadEndpointDetails
        """
        return self._read_endpoint

    @read_endpoint.setter
    def read_endpoint(self, read_endpoint):
        """
        Sets the read_endpoint of this DbSystemSummary.

        :param read_endpoint: The read_endpoint of this DbSystemSummary.
        :type: oci.mysql.models.ReadEndpointDetails
        """
        self._read_endpoint = read_endpoint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
