# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMaintenanceDetails(object):
    """
    The Maintenance Policy for the DB System or Read Replica that this model is included in.
    """

    #: A constant which can be used with the version_preference property of a UpdateMaintenanceDetails.
    #: This constant has a value of "OLDEST"
    VERSION_PREFERENCE_OLDEST = "OLDEST"

    #: A constant which can be used with the version_preference property of a UpdateMaintenanceDetails.
    #: This constant has a value of "SECOND_NEWEST"
    VERSION_PREFERENCE_SECOND_NEWEST = "SECOND_NEWEST"

    #: A constant which can be used with the version_preference property of a UpdateMaintenanceDetails.
    #: This constant has a value of "NEWEST"
    VERSION_PREFERENCE_NEWEST = "NEWEST"

    #: A constant which can be used with the version_track_preference property of a UpdateMaintenanceDetails.
    #: This constant has a value of "LONG_TERM_SUPPORT"
    VERSION_TRACK_PREFERENCE_LONG_TERM_SUPPORT = "LONG_TERM_SUPPORT"

    #: A constant which can be used with the version_track_preference property of a UpdateMaintenanceDetails.
    #: This constant has a value of "INNOVATION"
    VERSION_TRACK_PREFERENCE_INNOVATION = "INNOVATION"

    #: A constant which can be used with the version_track_preference property of a UpdateMaintenanceDetails.
    #: This constant has a value of "FOLLOW"
    VERSION_TRACK_PREFERENCE_FOLLOW = "FOLLOW"

    #: A constant which can be used with the maintenance_schedule_type property of a UpdateMaintenanceDetails.
    #: This constant has a value of "EARLY"
    MAINTENANCE_SCHEDULE_TYPE_EARLY = "EARLY"

    #: A constant which can be used with the maintenance_schedule_type property of a UpdateMaintenanceDetails.
    #: This constant has a value of "REGULAR"
    MAINTENANCE_SCHEDULE_TYPE_REGULAR = "REGULAR"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMaintenanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param window_start_time:
            The value to assign to the window_start_time property of this UpdateMaintenanceDetails.
        :type window_start_time: str

        :param version_preference:
            The value to assign to the version_preference property of this UpdateMaintenanceDetails.
            Allowed values for this property are: "OLDEST", "SECOND_NEWEST", "NEWEST"
        :type version_preference: str

        :param version_track_preference:
            The value to assign to the version_track_preference property of this UpdateMaintenanceDetails.
            Allowed values for this property are: "LONG_TERM_SUPPORT", "INNOVATION", "FOLLOW"
        :type version_track_preference: str

        :param maintenance_schedule_type:
            The value to assign to the maintenance_schedule_type property of this UpdateMaintenanceDetails.
            Allowed values for this property are: "EARLY", "REGULAR"
        :type maintenance_schedule_type: str

        """
        self.swagger_types = {
            'window_start_time': 'str',
            'version_preference': 'str',
            'version_track_preference': 'str',
            'maintenance_schedule_type': 'str'
        }
        self.attribute_map = {
            'window_start_time': 'windowStartTime',
            'version_preference': 'versionPreference',
            'version_track_preference': 'versionTrackPreference',
            'maintenance_schedule_type': 'maintenanceScheduleType'
        }
        self._window_start_time = None
        self._version_preference = None
        self._version_track_preference = None
        self._maintenance_schedule_type = None

    @property
    def window_start_time(self):
        """
        Gets the window_start_time of this UpdateMaintenanceDetails.
        The start of the 2 hour maintenance window.

        This string is of the format: \"{day-of-week} {time-of-day}\".

        \"{day-of-week}\" is a case-insensitive string like \"mon\", \"tue\", &c.

        \"{time-of-day}\" is the \"Time\" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        If you set the read replica maintenance window to \"\", the read replica is set same as the DB system maintenance window. If not specific by the user,
        there will be no changes to the maintenace window.


        :return: The window_start_time of this UpdateMaintenanceDetails.
        :rtype: str
        """
        return self._window_start_time

    @window_start_time.setter
    def window_start_time(self, window_start_time):
        """
        Sets the window_start_time of this UpdateMaintenanceDetails.
        The start of the 2 hour maintenance window.

        This string is of the format: \"{day-of-week} {time-of-day}\".

        \"{day-of-week}\" is a case-insensitive string like \"mon\", \"tue\", &c.

        \"{time-of-day}\" is the \"Time\" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        If you set the read replica maintenance window to \"\", the read replica is set same as the DB system maintenance window. If not specific by the user,
        there will be no changes to the maintenace window.


        :param window_start_time: The window_start_time of this UpdateMaintenanceDetails.
        :type: str
        """
        self._window_start_time = window_start_time

    @property
    def version_preference(self):
        """
        Gets the version_preference of this UpdateMaintenanceDetails.
        The preferred version to target when performing an automatic MySQL upgrade. Defaults to OLDEST.

        OLDEST: Choose the oldest available MySQL version based on the current version of the DB System.
        SECOND_NEWEST: Choose the MySQL version before the newest for auto-upgrade.
        NEWEST: Choose the latest and greatest MySQL version available for auto-upgrade.

        Allowed values for this property are: "OLDEST", "SECOND_NEWEST", "NEWEST"


        :return: The version_preference of this UpdateMaintenanceDetails.
        :rtype: str
        """
        return self._version_preference

    @version_preference.setter
    def version_preference(self, version_preference):
        """
        Sets the version_preference of this UpdateMaintenanceDetails.
        The preferred version to target when performing an automatic MySQL upgrade. Defaults to OLDEST.

        OLDEST: Choose the oldest available MySQL version based on the current version of the DB System.
        SECOND_NEWEST: Choose the MySQL version before the newest for auto-upgrade.
        NEWEST: Choose the latest and greatest MySQL version available for auto-upgrade.


        :param version_preference: The version_preference of this UpdateMaintenanceDetails.
        :type: str
        """
        allowed_values = ["OLDEST", "SECOND_NEWEST", "NEWEST"]
        if not value_allowed_none_or_none_sentinel(version_preference, allowed_values):
            raise ValueError(
                f"Invalid value for `version_preference`, must be None or one of {allowed_values}"
            )
        self._version_preference = version_preference

    @property
    def version_track_preference(self):
        """
        Gets the version_track_preference of this UpdateMaintenanceDetails.
        The preferred version track to target when performing an automatic MySQL upgrade. Defaults to FOLLOW.
        LONG_TERM_SUPPORT: No MySQL database behavior changes.
        INNOVATION:        Provides access to the latest features and all bug fixes.
        FOLLOW:            Follows the track of the current MySQL version.

        Allowed values for this property are: "LONG_TERM_SUPPORT", "INNOVATION", "FOLLOW"


        :return: The version_track_preference of this UpdateMaintenanceDetails.
        :rtype: str
        """
        return self._version_track_preference

    @version_track_preference.setter
    def version_track_preference(self, version_track_preference):
        """
        Sets the version_track_preference of this UpdateMaintenanceDetails.
        The preferred version track to target when performing an automatic MySQL upgrade. Defaults to FOLLOW.
        LONG_TERM_SUPPORT: No MySQL database behavior changes.
        INNOVATION:        Provides access to the latest features and all bug fixes.
        FOLLOW:            Follows the track of the current MySQL version.


        :param version_track_preference: The version_track_preference of this UpdateMaintenanceDetails.
        :type: str
        """
        allowed_values = ["LONG_TERM_SUPPORT", "INNOVATION", "FOLLOW"]
        if not value_allowed_none_or_none_sentinel(version_track_preference, allowed_values):
            raise ValueError(
                f"Invalid value for `version_track_preference`, must be None or one of {allowed_values}"
            )
        self._version_track_preference = version_track_preference

    @property
    def maintenance_schedule_type(self):
        """
        Gets the maintenance_schedule_type of this UpdateMaintenanceDetails.
        The maintenance schedule type of the DB system. Defaults to REGULAR.
        EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated.
        REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.

        Allowed values for this property are: "EARLY", "REGULAR"


        :return: The maintenance_schedule_type of this UpdateMaintenanceDetails.
        :rtype: str
        """
        return self._maintenance_schedule_type

    @maintenance_schedule_type.setter
    def maintenance_schedule_type(self, maintenance_schedule_type):
        """
        Sets the maintenance_schedule_type of this UpdateMaintenanceDetails.
        The maintenance schedule type of the DB system. Defaults to REGULAR.
        EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated.
        REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.


        :param maintenance_schedule_type: The maintenance_schedule_type of this UpdateMaintenanceDetails.
        :type: str
        """
        allowed_values = ["EARLY", "REGULAR"]
        if not value_allowed_none_or_none_sentinel(maintenance_schedule_type, allowed_values):
            raise ValueError(
                f"Invalid value for `maintenance_schedule_type`, must be None or one of {allowed_values}"
            )
        self._maintenance_schedule_type = maintenance_schedule_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
