# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NatRuleMatchCriteria(object):
    """
    Match criteria used in NAT rule used on the firewall policy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NatRuleMatchCriteria object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_address:
            The value to assign to the source_address property of this NatRuleMatchCriteria.
        :type source_address: list[str]

        :param destination_address:
            The value to assign to the destination_address property of this NatRuleMatchCriteria.
        :type destination_address: list[str]

        :param service:
            The value to assign to the service property of this NatRuleMatchCriteria.
        :type service: str

        """
        self.swagger_types = {
            'source_address': 'list[str]',
            'destination_address': 'list[str]',
            'service': 'str'
        }
        self.attribute_map = {
            'source_address': 'sourceAddress',
            'destination_address': 'destinationAddress',
            'service': 'service'
        }
        self._source_address = None
        self._destination_address = None
        self._service = None

    @property
    def source_address(self):
        """
        Gets the source_address of this NatRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic source address.


        :return: The source_address of this NatRuleMatchCriteria.
        :rtype: list[str]
        """
        return self._source_address

    @source_address.setter
    def source_address(self, source_address):
        """
        Sets the source_address of this NatRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic source address.


        :param source_address: The source_address of this NatRuleMatchCriteria.
        :type: list[str]
        """
        self._source_address = source_address

    @property
    def destination_address(self):
        """
        Gets the destination_address of this NatRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic destination address.


        :return: The destination_address of this NatRuleMatchCriteria.
        :rtype: list[str]
        """
        return self._destination_address

    @destination_address.setter
    def destination_address(self, destination_address):
        """
        Sets the destination_address of this NatRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic destination address.


        :param destination_address: The destination_address of this NatRuleMatchCriteria.
        :type: list[str]
        """
        self._destination_address = destination_address

    @property
    def service(self):
        """
        Gets the service of this NatRuleMatchCriteria.
        A Service name to be evaluated against the traffic protocol and protocol-specific parameters.


        :return: The service of this NatRuleMatchCriteria.
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this NatRuleMatchCriteria.
        A Service name to be evaluated against the traffic protocol and protocol-specific parameters.


        :param service: The service of this NatRuleMatchCriteria.
        :type: str
        """
        self._service = service

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
