# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ClusterSummary(object):
    """
    A summary of the Cluster.
    """

    #: A constant which can be used with the lifecycle_state property of a ClusterSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ClusterSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ClusterSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ClusterSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ClusterSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ClusterSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the vsphere_type property of a ClusterSummary.
    #: This constant has a value of "MANAGEMENT"
    VSPHERE_TYPE_MANAGEMENT = "MANAGEMENT"

    #: A constant which can be used with the vsphere_type property of a ClusterSummary.
    #: This constant has a value of "WORKLOAD"
    VSPHERE_TYPE_WORKLOAD = "WORKLOAD"

    def __init__(self, **kwargs):
        """
        Initializes a new ClusterSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ClusterSummary.
        :type id: str

        :param compute_availability_domain:
            The value to assign to the compute_availability_domain property of this ClusterSummary.
        :type compute_availability_domain: str

        :param sddc_id:
            The value to assign to the sddc_id property of this ClusterSummary.
        :type sddc_id: str

        :param display_name:
            The value to assign to the display_name property of this ClusterSummary.
        :type display_name: str

        :param vmware_software_version:
            The value to assign to the vmware_software_version property of this ClusterSummary.
        :type vmware_software_version: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ClusterSummary.
        :type compartment_id: str

        :param esxi_hosts_count:
            The value to assign to the esxi_hosts_count property of this ClusterSummary.
        :type esxi_hosts_count: int

        :param time_created:
            The value to assign to the time_created property of this ClusterSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ClusterSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ClusterSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param is_shielded_instance_enabled:
            The value to assign to the is_shielded_instance_enabled property of this ClusterSummary.
        :type is_shielded_instance_enabled: bool

        :param initial_host_shape_name:
            The value to assign to the initial_host_shape_name property of this ClusterSummary.
        :type initial_host_shape_name: str

        :param initial_host_ocpu_count:
            The value to assign to the initial_host_ocpu_count property of this ClusterSummary.
        :type initial_host_ocpu_count: float

        :param vsphere_type:
            The value to assign to the vsphere_type property of this ClusterSummary.
            Allowed values for this property are: "MANAGEMENT", "WORKLOAD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vsphere_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ClusterSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ClusterSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ClusterSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compute_availability_domain': 'str',
            'sddc_id': 'str',
            'display_name': 'str',
            'vmware_software_version': 'str',
            'compartment_id': 'str',
            'esxi_hosts_count': 'int',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'is_shielded_instance_enabled': 'bool',
            'initial_host_shape_name': 'str',
            'initial_host_ocpu_count': 'float',
            'vsphere_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compute_availability_domain': 'computeAvailabilityDomain',
            'sddc_id': 'sddcId',
            'display_name': 'displayName',
            'vmware_software_version': 'vmwareSoftwareVersion',
            'compartment_id': 'compartmentId',
            'esxi_hosts_count': 'esxiHostsCount',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'is_shielded_instance_enabled': 'isShieldedInstanceEnabled',
            'initial_host_shape_name': 'initialHostShapeName',
            'initial_host_ocpu_count': 'initialHostOcpuCount',
            'vsphere_type': 'vsphereType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compute_availability_domain = None
        self._sddc_id = None
        self._display_name = None
        self._vmware_software_version = None
        self._compartment_id = None
        self._esxi_hosts_count = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._is_shielded_instance_enabled = None
        self._initial_host_shape_name = None
        self._initial_host_ocpu_count = None
        self._vsphere_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ClusterSummary.
        The `OCID`__ of the compartment that
        contains the Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this ClusterSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ClusterSummary.
        The `OCID`__ of the compartment that
        contains the Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this ClusterSummary.
        :type: str
        """
        self._id = id

    @property
    def compute_availability_domain(self):
        """
        **[Required]** Gets the compute_availability_domain of this ClusterSummary.
        The availability domain that the Cluster's ESXi hosts are running in. For Multi-AD Cluster, it is `multi-AD`.


        :return: The compute_availability_domain of this ClusterSummary.
        :rtype: str
        """
        return self._compute_availability_domain

    @compute_availability_domain.setter
    def compute_availability_domain(self, compute_availability_domain):
        """
        Sets the compute_availability_domain of this ClusterSummary.
        The availability domain that the Cluster's ESXi hosts are running in. For Multi-AD Cluster, it is `multi-AD`.


        :param compute_availability_domain: The compute_availability_domain of this ClusterSummary.
        :type: str
        """
        self._compute_availability_domain = compute_availability_domain

    @property
    def sddc_id(self):
        """
        **[Required]** Gets the sddc_id of this ClusterSummary.
        The `OCID`__ of the SDDC that the
        Cluster belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The sddc_id of this ClusterSummary.
        :rtype: str
        """
        return self._sddc_id

    @sddc_id.setter
    def sddc_id(self, sddc_id):
        """
        Sets the sddc_id of this ClusterSummary.
        The `OCID`__ of the SDDC that the
        Cluster belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param sddc_id: The sddc_id of this ClusterSummary.
        :type: str
        """
        self._sddc_id = sddc_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ClusterSummary.
        A descriptive name for the Cluster. It must be unique, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :return: The display_name of this ClusterSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ClusterSummary.
        A descriptive name for the Cluster. It must be unique, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :param display_name: The display_name of this ClusterSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def vmware_software_version(self):
        """
        **[Required]** Gets the vmware_software_version of this ClusterSummary.
        In general, this is a specific version of bundled VMware software supported by
        Oracle Cloud VMware Solution (see
        :func:`list_supported_vmware_software_versions`).

        This attribute is not guaranteed to reflect the version of
        software currently installed on the ESXi hosts in the Cluster. The purpose
        of this attribute is to show the version of software that the Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        Cluster in the future* with :func:`create_esxi_host`.

        Therefore, if you upgrade the existing ESXi hosts in the Cluster to use a newer
        version of bundled VMware software supported by the Oracle Cloud VMware Solution, you
        should use :func:`update_cluster` to update the Cluster's
        `vmwareSoftwareVersion` with that new version.


        :return: The vmware_software_version of this ClusterSummary.
        :rtype: str
        """
        return self._vmware_software_version

    @vmware_software_version.setter
    def vmware_software_version(self, vmware_software_version):
        """
        Sets the vmware_software_version of this ClusterSummary.
        In general, this is a specific version of bundled VMware software supported by
        Oracle Cloud VMware Solution (see
        :func:`list_supported_vmware_software_versions`).

        This attribute is not guaranteed to reflect the version of
        software currently installed on the ESXi hosts in the Cluster. The purpose
        of this attribute is to show the version of software that the Oracle
        Cloud VMware Solution will install on any new ESXi hosts that you *add to this
        Cluster in the future* with :func:`create_esxi_host`.

        Therefore, if you upgrade the existing ESXi hosts in the Cluster to use a newer
        version of bundled VMware software supported by the Oracle Cloud VMware Solution, you
        should use :func:`update_cluster` to update the Cluster's
        `vmwareSoftwareVersion` with that new version.


        :param vmware_software_version: The vmware_software_version of this ClusterSummary.
        :type: str
        """
        self._vmware_software_version = vmware_software_version

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ClusterSummary.
        The `OCID`__ of the compartment that
        contains the Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ClusterSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ClusterSummary.
        The `OCID`__ of the compartment that
        contains the Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ClusterSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def esxi_hosts_count(self):
        """
        **[Required]** Gets the esxi_hosts_count of this ClusterSummary.
        The number of ESXi hosts in the Cluster.


        :return: The esxi_hosts_count of this ClusterSummary.
        :rtype: int
        """
        return self._esxi_hosts_count

    @esxi_hosts_count.setter
    def esxi_hosts_count(self, esxi_hosts_count):
        """
        Sets the esxi_hosts_count of this ClusterSummary.
        The number of ESXi hosts in the Cluster.


        :param esxi_hosts_count: The esxi_hosts_count of this ClusterSummary.
        :type: int
        """
        self._esxi_hosts_count = esxi_hosts_count

    @property
    def time_created(self):
        """
        Gets the time_created of this ClusterSummary.
        The date and time the Cluster was created, in the format defined by
        `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ClusterSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ClusterSummary.
        The date and time the Cluster was created, in the format defined by
        `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ClusterSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ClusterSummary.
        The date and time the Cluster was updated, in the format defined by
        `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ClusterSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ClusterSummary.
        The date and time the Cluster was updated, in the format defined by
        `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ClusterSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ClusterSummary.
        The current state of the Cluster.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ClusterSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ClusterSummary.
        The current state of the Cluster.


        :param lifecycle_state: The lifecycle_state of this ClusterSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def is_shielded_instance_enabled(self):
        """
        Gets the is_shielded_instance_enabled of this ClusterSummary.
        Indicates whether shielded instance is enabled at the Cluster level.


        :return: The is_shielded_instance_enabled of this ClusterSummary.
        :rtype: bool
        """
        return self._is_shielded_instance_enabled

    @is_shielded_instance_enabled.setter
    def is_shielded_instance_enabled(self, is_shielded_instance_enabled):
        """
        Sets the is_shielded_instance_enabled of this ClusterSummary.
        Indicates whether shielded instance is enabled at the Cluster level.


        :param is_shielded_instance_enabled: The is_shielded_instance_enabled of this ClusterSummary.
        :type: bool
        """
        self._is_shielded_instance_enabled = is_shielded_instance_enabled

    @property
    def initial_host_shape_name(self):
        """
        **[Required]** Gets the initial_host_shape_name of this ClusterSummary.
        The initial compute shape of the Cluster's ESXi hosts.
        :func:`list_supported_host_shapes`.


        :return: The initial_host_shape_name of this ClusterSummary.
        :rtype: str
        """
        return self._initial_host_shape_name

    @initial_host_shape_name.setter
    def initial_host_shape_name(self, initial_host_shape_name):
        """
        Sets the initial_host_shape_name of this ClusterSummary.
        The initial compute shape of the Cluster's ESXi hosts.
        :func:`list_supported_host_shapes`.


        :param initial_host_shape_name: The initial_host_shape_name of this ClusterSummary.
        :type: str
        """
        self._initial_host_shape_name = initial_host_shape_name

    @property
    def initial_host_ocpu_count(self):
        """
        Gets the initial_host_ocpu_count of this ClusterSummary.
        The initial OCPU count of the Cluster's ESXi hosts.


        :return: The initial_host_ocpu_count of this ClusterSummary.
        :rtype: float
        """
        return self._initial_host_ocpu_count

    @initial_host_ocpu_count.setter
    def initial_host_ocpu_count(self, initial_host_ocpu_count):
        """
        Sets the initial_host_ocpu_count of this ClusterSummary.
        The initial OCPU count of the Cluster's ESXi hosts.


        :param initial_host_ocpu_count: The initial_host_ocpu_count of this ClusterSummary.
        :type: float
        """
        self._initial_host_ocpu_count = initial_host_ocpu_count

    @property
    def vsphere_type(self):
        """
        **[Required]** Gets the vsphere_type of this ClusterSummary.
        vSphere Cluster types.

        Allowed values for this property are: "MANAGEMENT", "WORKLOAD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vsphere_type of this ClusterSummary.
        :rtype: str
        """
        return self._vsphere_type

    @vsphere_type.setter
    def vsphere_type(self, vsphere_type):
        """
        Sets the vsphere_type of this ClusterSummary.
        vSphere Cluster types.


        :param vsphere_type: The vsphere_type of this ClusterSummary.
        :type: str
        """
        allowed_values = ["MANAGEMENT", "WORKLOAD"]
        if not value_allowed_none_or_none_sentinel(vsphere_type, allowed_values):
            vsphere_type = 'UNKNOWN_ENUM_VALUE'
        self._vsphere_type = vsphere_type

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ClusterSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ClusterSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ClusterSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :return: The system_tags of this ClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ClusterSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :param system_tags: The system_tags of this ClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
