# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateManagementApplianceDetails(object):
    """
    Information about management appliance to be created.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateManagementApplianceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sddc_id:
            The value to assign to the sddc_id property of this CreateManagementApplianceDetails.
        :type sddc_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateManagementApplianceDetails.
        :type display_name: str

        :param configuration:
            The value to assign to the configuration property of this CreateManagementApplianceDetails.
        :type configuration: oci.ocvp.models.ManagementApplianceConfiguration

        :param connections:
            The value to assign to the connections property of this CreateManagementApplianceDetails.
        :type connections: list[oci.ocvp.models.ManagementApplianceConnection]

        :param public_ssh_keys:
            The value to assign to the public_ssh_keys property of this CreateManagementApplianceDetails.
        :type public_ssh_keys: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateManagementApplianceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateManagementApplianceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'sddc_id': 'str',
            'display_name': 'str',
            'configuration': 'ManagementApplianceConfiguration',
            'connections': 'list[ManagementApplianceConnection]',
            'public_ssh_keys': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'sddc_id': 'sddcId',
            'display_name': 'displayName',
            'configuration': 'configuration',
            'connections': 'connections',
            'public_ssh_keys': 'publicSshKeys',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._sddc_id = None
        self._display_name = None
        self._configuration = None
        self._connections = None
        self._public_ssh_keys = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def sddc_id(self):
        """
        **[Required]** Gets the sddc_id of this CreateManagementApplianceDetails.
        The `OCID`__ of SDDC in OCI, that this appliance is going to be registered in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The sddc_id of this CreateManagementApplianceDetails.
        :rtype: str
        """
        return self._sddc_id

    @sddc_id.setter
    def sddc_id(self, sddc_id):
        """
        Sets the sddc_id of this CreateManagementApplianceDetails.
        The `OCID`__ of SDDC in OCI, that this appliance is going to be registered in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param sddc_id: The sddc_id of this CreateManagementApplianceDetails.
        :type: str
        """
        self._sddc_id = sddc_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateManagementApplianceDetails.
        A descriptive name for the management appliance. It must be unique, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.


        :return: The display_name of this CreateManagementApplianceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateManagementApplianceDetails.
        A descriptive name for the management appliance. It must be unique, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.


        :param display_name: The display_name of this CreateManagementApplianceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def configuration(self):
        """
        **[Required]** Gets the configuration of this CreateManagementApplianceDetails.

        :return: The configuration of this CreateManagementApplianceDetails.
        :rtype: oci.ocvp.models.ManagementApplianceConfiguration
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this CreateManagementApplianceDetails.

        :param configuration: The configuration of this CreateManagementApplianceDetails.
        :type: oci.ocvp.models.ManagementApplianceConfiguration
        """
        self._configuration = configuration

    @property
    def connections(self):
        """
        **[Required]** Gets the connections of this CreateManagementApplianceDetails.
        Array of connections for management appliance.


        :return: The connections of this CreateManagementApplianceDetails.
        :rtype: list[oci.ocvp.models.ManagementApplianceConnection]
        """
        return self._connections

    @connections.setter
    def connections(self, connections):
        """
        Sets the connections of this CreateManagementApplianceDetails.
        Array of connections for management appliance.


        :param connections: The connections of this CreateManagementApplianceDetails.
        :type: list[oci.ocvp.models.ManagementApplianceConnection]
        """
        self._connections = connections

    @property
    def public_ssh_keys(self):
        """
        Gets the public_ssh_keys of this CreateManagementApplianceDetails.
        One or more public SSH keys to be included in `~/.ssh/authorized_keys` file for Management Appliance compute instance.
        Several public SSH keys must be separate by newline character.


        :return: The public_ssh_keys of this CreateManagementApplianceDetails.
        :rtype: str
        """
        return self._public_ssh_keys

    @public_ssh_keys.setter
    def public_ssh_keys(self, public_ssh_keys):
        """
        Sets the public_ssh_keys of this CreateManagementApplianceDetails.
        One or more public SSH keys to be included in `~/.ssh/authorized_keys` file for Management Appliance compute instance.
        Several public SSH keys must be separate by newline character.


        :param public_ssh_keys: The public_ssh_keys of this CreateManagementApplianceDetails.
        :type: str
        """
        self._public_ssh_keys = public_ssh_keys

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateManagementApplianceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateManagementApplianceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateManagementApplianceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateManagementApplianceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateManagementApplianceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateManagementApplianceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateManagementApplianceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateManagementApplianceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
