# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatastoreAttachment(object):
    """
    The details about attachment of datastore
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatastoreAttachment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param volume_iqn:
            The value to assign to the volume_iqn property of this DatastoreAttachment.
        :type volume_iqn: str

        :param block_volume_id:
            The value to assign to the block_volume_id property of this DatastoreAttachment.
        :type block_volume_id: str

        :param datastore_id:
            The value to assign to the datastore_id property of this DatastoreAttachment.
        :type datastore_id: str

        :param ip_address:
            The value to assign to the ip_address property of this DatastoreAttachment.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this DatastoreAttachment.
        :type port: int

        """
        self.swagger_types = {
            'volume_iqn': 'str',
            'block_volume_id': 'str',
            'datastore_id': 'str',
            'ip_address': 'str',
            'port': 'int'
        }
        self.attribute_map = {
            'volume_iqn': 'volumeIqn',
            'block_volume_id': 'blockVolumeId',
            'datastore_id': 'datastoreId',
            'ip_address': 'ipAddress',
            'port': 'port'
        }
        self._volume_iqn = None
        self._block_volume_id = None
        self._datastore_id = None
        self._ip_address = None
        self._port = None

    @property
    def volume_iqn(self):
        """
        **[Required]** Gets the volume_iqn of this DatastoreAttachment.
        An IQN of the Block Storage Volume.


        :return: The volume_iqn of this DatastoreAttachment.
        :rtype: str
        """
        return self._volume_iqn

    @volume_iqn.setter
    def volume_iqn(self, volume_iqn):
        """
        Sets the volume_iqn of this DatastoreAttachment.
        An IQN of the Block Storage Volume.


        :param volume_iqn: The volume_iqn of this DatastoreAttachment.
        :type: str
        """
        self._volume_iqn = volume_iqn

    @property
    def block_volume_id(self):
        """
        **[Required]** Gets the block_volume_id of this DatastoreAttachment.
        The `OCID`__ of the Block Volume that belongs to the datastore.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The block_volume_id of this DatastoreAttachment.
        :rtype: str
        """
        return self._block_volume_id

    @block_volume_id.setter
    def block_volume_id(self, block_volume_id):
        """
        Sets the block_volume_id of this DatastoreAttachment.
        The `OCID`__ of the Block Volume that belongs to the datastore.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param block_volume_id: The block_volume_id of this DatastoreAttachment.
        :type: str
        """
        self._block_volume_id = block_volume_id

    @property
    def datastore_id(self):
        """
        **[Required]** Gets the datastore_id of this DatastoreAttachment.
        The `OCIDs`__ of the Datastore that ESXi host is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The datastore_id of this DatastoreAttachment.
        :rtype: str
        """
        return self._datastore_id

    @datastore_id.setter
    def datastore_id(self, datastore_id):
        """
        Sets the datastore_id of this DatastoreAttachment.
        The `OCIDs`__ of the Datastore that ESXi host is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param datastore_id: The datastore_id of this DatastoreAttachment.
        :type: str
        """
        self._datastore_id = datastore_id

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this DatastoreAttachment.
        The IP address of datastore attachment.


        :return: The ip_address of this DatastoreAttachment.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this DatastoreAttachment.
        The IP address of datastore attachment.


        :param ip_address: The ip_address of this DatastoreAttachment.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        **[Required]** Gets the port of this DatastoreAttachment.
        The port of datastore attachment.


        :return: The port of this DatastoreAttachment.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this DatastoreAttachment.
        The port of datastore attachment.


        :param port: The port of this DatastoreAttachment.
        :type: int
        """
        self._port = port

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
