# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190506


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EntityActionArgument(object):
    """
    Argument of an entity action
    """

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "TEXT"
    TYPE_TEXT = "TEXT"

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "NUMBER"
    TYPE_NUMBER = "NUMBER"

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "DATE_TIME"
    TYPE_DATE_TIME = "DATE_TIME"

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "DATE"
    TYPE_DATE = "DATE"

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "ENTITY"
    TYPE_ENTITY = "ENTITY"

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "COMPOSITE_ENTITY"
    TYPE_COMPOSITE_ENTITY = "COMPOSITE_ENTITY"

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "ATTRIBUTE_REFERENCE"
    TYPE_ATTRIBUTE_REFERENCE = "ATTRIBUTE_REFERENCE"

    #: A constant which can be used with the type property of a EntityActionArgument.
    #: This constant has a value of "BOOLEAN"
    TYPE_BOOLEAN = "BOOLEAN"

    def __init__(self, **kwargs):
        """
        Initializes a new EntityActionArgument object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this EntityActionArgument.
        :type name: str

        :param type:
            The value to assign to the type property of this EntityActionArgument.
            Allowed values for this property are: "TEXT", "NUMBER", "DATE_TIME", "DATE", "ENTITY", "COMPOSITE_ENTITY", "ATTRIBUTE_REFERENCE", "BOOLEAN"
        :type type: str

        :param meta_type:
            The value to assign to the meta_type property of this EntityActionArgument.
        :type meta_type: str

        :param natural_language_mapping:
            The value to assign to the natural_language_mapping property of this EntityActionArgument.
        :type natural_language_mapping: oci.oda.models.EntityActionArgumentNaturalLanguageMapping

        :param is_multi_value:
            The value to assign to the is_multi_value property of this EntityActionArgument.
        :type is_multi_value: bool

        :param entity_name:
            The value to assign to the entity_name property of this EntityActionArgument.
        :type entity_name: str

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'meta_type': 'str',
            'natural_language_mapping': 'EntityActionArgumentNaturalLanguageMapping',
            'is_multi_value': 'bool',
            'entity_name': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'meta_type': 'metaType',
            'natural_language_mapping': 'naturalLanguageMapping',
            'is_multi_value': 'isMultiValue',
            'entity_name': 'entityName'
        }
        self._name = None
        self._type = None
        self._meta_type = None
        self._natural_language_mapping = None
        self._is_multi_value = None
        self._entity_name = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this EntityActionArgument.
        Name of an entity action argument


        :return: The name of this EntityActionArgument.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EntityActionArgument.
        Name of an entity action argument


        :param name: The name of this EntityActionArgument.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this EntityActionArgument.
        Type of an entity action argument

        Allowed values for this property are: "TEXT", "NUMBER", "DATE_TIME", "DATE", "ENTITY", "COMPOSITE_ENTITY", "ATTRIBUTE_REFERENCE", "BOOLEAN"


        :return: The type of this EntityActionArgument.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this EntityActionArgument.
        Type of an entity action argument


        :param type: The type of this EntityActionArgument.
        :type: str
        """
        allowed_values = ["TEXT", "NUMBER", "DATE_TIME", "DATE", "ENTITY", "COMPOSITE_ENTITY", "ATTRIBUTE_REFERENCE", "BOOLEAN"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def meta_type(self):
        """
        Gets the meta_type of this EntityActionArgument.
        Metatype of an entity action argument


        :return: The meta_type of this EntityActionArgument.
        :rtype: str
        """
        return self._meta_type

    @meta_type.setter
    def meta_type(self, meta_type):
        """
        Sets the meta_type of this EntityActionArgument.
        Metatype of an entity action argument


        :param meta_type: The meta_type of this EntityActionArgument.
        :type: str
        """
        self._meta_type = meta_type

    @property
    def natural_language_mapping(self):
        """
        Gets the natural_language_mapping of this EntityActionArgument.

        :return: The natural_language_mapping of this EntityActionArgument.
        :rtype: oci.oda.models.EntityActionArgumentNaturalLanguageMapping
        """
        return self._natural_language_mapping

    @natural_language_mapping.setter
    def natural_language_mapping(self, natural_language_mapping):
        """
        Sets the natural_language_mapping of this EntityActionArgument.

        :param natural_language_mapping: The natural_language_mapping of this EntityActionArgument.
        :type: oci.oda.models.EntityActionArgumentNaturalLanguageMapping
        """
        self._natural_language_mapping = natural_language_mapping

    @property
    def is_multi_value(self):
        """
        Gets the is_multi_value of this EntityActionArgument.
        Is the entity action argument multi-value


        :return: The is_multi_value of this EntityActionArgument.
        :rtype: bool
        """
        return self._is_multi_value

    @is_multi_value.setter
    def is_multi_value(self, is_multi_value):
        """
        Sets the is_multi_value of this EntityActionArgument.
        Is the entity action argument multi-value


        :param is_multi_value: The is_multi_value of this EntityActionArgument.
        :type: bool
        """
        self._is_multi_value = is_multi_value

    @property
    def entity_name(self):
        """
        Gets the entity_name of this EntityActionArgument.
        Name of referenced entity.


        :return: The entity_name of this EntityActionArgument.
        :rtype: str
        """
        return self._entity_name

    @entity_name.setter
    def entity_name(self, entity_name):
        """
        Sets the entity_name of this EntityActionArgument.
        Name of referenced entity.


        :param entity_name: The entity_name of this EntityActionArgument.
        :type: str
        """
        self._entity_name = entity_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
