# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssignmentValidationStatus(object):
    """
    Summary of assignment Validation status.
    """

    #: A constant which can be used with the execution_status property of a AssignmentValidationStatus.
    #: This constant has a value of "PROGRESS"
    EXECUTION_STATUS_PROGRESS = "PROGRESS"

    #: A constant which can be used with the execution_status property of a AssignmentValidationStatus.
    #: This constant has a value of "SUCCESS"
    EXECUTION_STATUS_SUCCESS = "SUCCESS"

    #: A constant which can be used with the execution_status property of a AssignmentValidationStatus.
    #: This constant has a value of "FAILED"
    EXECUTION_STATUS_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new AssignmentValidationStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param execution_id:
            The value to assign to the execution_id property of this AssignmentValidationStatus.
        :type execution_id: str

        :param user_id:
            The value to assign to the user_id property of this AssignmentValidationStatus.
        :type user_id: str

        :param access_request_id:
            The value to assign to the access_request_id property of this AssignmentValidationStatus.
        :type access_request_id: str

        :param error_message:
            The value to assign to the error_message property of this AssignmentValidationStatus.
        :type error_message: str

        :param execution_status:
            The value to assign to the execution_status property of this AssignmentValidationStatus.
            Allowed values for this property are: "PROGRESS", "SUCCESS", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type execution_status: str

        :param status_detail:
            The value to assign to the status_detail property of this AssignmentValidationStatus.
        :type status_detail: list[oci.operator_access_control.models.StatusDetail]

        :param time_of_validation_start:
            The value to assign to the time_of_validation_start property of this AssignmentValidationStatus.
        :type time_of_validation_start: datetime

        :param time_of_validation_finish:
            The value to assign to the time_of_validation_finish property of this AssignmentValidationStatus.
        :type time_of_validation_finish: datetime

        """
        self.swagger_types = {
            'execution_id': 'str',
            'user_id': 'str',
            'access_request_id': 'str',
            'error_message': 'str',
            'execution_status': 'str',
            'status_detail': 'list[StatusDetail]',
            'time_of_validation_start': 'datetime',
            'time_of_validation_finish': 'datetime'
        }
        self.attribute_map = {
            'execution_id': 'executionId',
            'user_id': 'userId',
            'access_request_id': 'accessRequestId',
            'error_message': 'errorMessage',
            'execution_status': 'executionStatus',
            'status_detail': 'statusDetail',
            'time_of_validation_start': 'timeOfValidationStart',
            'time_of_validation_finish': 'timeOfValidationFinish'
        }
        self._execution_id = None
        self._user_id = None
        self._access_request_id = None
        self._error_message = None
        self._execution_status = None
        self._status_detail = None
        self._time_of_validation_start = None
        self._time_of_validation_finish = None

    @property
    def execution_id(self):
        """
        **[Required]** Gets the execution_id of this AssignmentValidationStatus.
        Id of the unique execution.


        :return: The execution_id of this AssignmentValidationStatus.
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """
        Sets the execution_id of this AssignmentValidationStatus.
        Id of the unique execution.


        :param execution_id: The execution_id of this AssignmentValidationStatus.
        :type: str
        """
        self._execution_id = execution_id

    @property
    def user_id(self):
        """
        Gets the user_id of this AssignmentValidationStatus.
        Id of the user who triggered the Assignment Validation.


        :return: The user_id of this AssignmentValidationStatus.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this AssignmentValidationStatus.
        Id of the user who triggered the Assignment Validation.


        :param user_id: The user_id of this AssignmentValidationStatus.
        :type: str
        """
        self._user_id = user_id

    @property
    def access_request_id(self):
        """
        Gets the access_request_id of this AssignmentValidationStatus.
        Id of the accessRequest which got created as part of Assignment Validation.


        :return: The access_request_id of this AssignmentValidationStatus.
        :rtype: str
        """
        return self._access_request_id

    @access_request_id.setter
    def access_request_id(self, access_request_id):
        """
        Sets the access_request_id of this AssignmentValidationStatus.
        Id of the accessRequest which got created as part of Assignment Validation.


        :param access_request_id: The access_request_id of this AssignmentValidationStatus.
        :type: str
        """
        self._access_request_id = access_request_id

    @property
    def error_message(self):
        """
        Gets the error_message of this AssignmentValidationStatus.
        any errorMessage during validation.


        :return: The error_message of this AssignmentValidationStatus.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this AssignmentValidationStatus.
        any errorMessage during validation.


        :param error_message: The error_message of this AssignmentValidationStatus.
        :type: str
        """
        self._error_message = error_message

    @property
    def execution_status(self):
        """
        **[Required]** Gets the execution_status of this AssignmentValidationStatus.
        Status of the execution Success or Failure.

        Allowed values for this property are: "PROGRESS", "SUCCESS", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The execution_status of this AssignmentValidationStatus.
        :rtype: str
        """
        return self._execution_status

    @execution_status.setter
    def execution_status(self, execution_status):
        """
        Sets the execution_status of this AssignmentValidationStatus.
        Status of the execution Success or Failure.


        :param execution_status: The execution_status of this AssignmentValidationStatus.
        :type: str
        """
        allowed_values = ["PROGRESS", "SUCCESS", "FAILED"]
        if not value_allowed_none_or_none_sentinel(execution_status, allowed_values):
            execution_status = 'UNKNOWN_ENUM_VALUE'
        self._execution_status = execution_status

    @property
    def status_detail(self):
        """
        Gets the status_detail of this AssignmentValidationStatus.
        List of execution detail for the validate assignment.


        :return: The status_detail of this AssignmentValidationStatus.
        :rtype: list[oci.operator_access_control.models.StatusDetail]
        """
        return self._status_detail

    @status_detail.setter
    def status_detail(self, status_detail):
        """
        Sets the status_detail of this AssignmentValidationStatus.
        List of execution detail for the validate assignment.


        :param status_detail: The status_detail of this AssignmentValidationStatus.
        :type: list[oci.operator_access_control.models.StatusDetail]
        """
        self._status_detail = status_detail

    @property
    def time_of_validation_start(self):
        """
        Gets the time_of_validation_start of this AssignmentValidationStatus.
        Time when the respective action happened in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_of_validation_start of this AssignmentValidationStatus.
        :rtype: datetime
        """
        return self._time_of_validation_start

    @time_of_validation_start.setter
    def time_of_validation_start(self, time_of_validation_start):
        """
        Sets the time_of_validation_start of this AssignmentValidationStatus.
        Time when the respective action happened in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_of_validation_start: The time_of_validation_start of this AssignmentValidationStatus.
        :type: datetime
        """
        self._time_of_validation_start = time_of_validation_start

    @property
    def time_of_validation_finish(self):
        """
        Gets the time_of_validation_finish of this AssignmentValidationStatus.
        Time when the respective action happened in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_of_validation_finish of this AssignmentValidationStatus.
        :rtype: datetime
        """
        return self._time_of_validation_finish

    @time_of_validation_finish.setter
    def time_of_validation_finish(self, time_of_validation_finish):
        """
        Sets the time_of_validation_finish of this AssignmentValidationStatus.
        Time when the respective action happened in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_of_validation_finish: The time_of_validation_finish of this AssignmentValidationStatus.
        :type: datetime
        """
        self._time_of_validation_finish = time_of_validation_finish

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
