# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttachLifecycleStageToProfileDetails(object):
    """
    Provides the information used to attach a lifecycle stage to a profile.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AttachLifecycleStageToProfileDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param lifecycle_stage_id:
            The value to assign to the lifecycle_stage_id property of this AttachLifecycleStageToProfileDetails.
        :type lifecycle_stage_id: str

        """
        self.swagger_types = {
            'lifecycle_stage_id': 'str'
        }
        self.attribute_map = {
            'lifecycle_stage_id': 'lifecycleStageId'
        }
        self._lifecycle_stage_id = None

    @property
    def lifecycle_stage_id(self):
        """
        **[Required]** Gets the lifecycle_stage_id of this AttachLifecycleStageToProfileDetails.
        The `OCID`__ of the lifecycle stage that the instance will be associated with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The lifecycle_stage_id of this AttachLifecycleStageToProfileDetails.
        :rtype: str
        """
        return self._lifecycle_stage_id

    @lifecycle_stage_id.setter
    def lifecycle_stage_id(self, lifecycle_stage_id):
        """
        Sets the lifecycle_stage_id of this AttachLifecycleStageToProfileDetails.
        The `OCID`__ of the lifecycle stage that the instance will be associated with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param lifecycle_stage_id: The lifecycle_stage_id of this AttachLifecycleStageToProfileDetails.
        :type: str
        """
        self._lifecycle_stage_id = lifecycle_stage_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
