# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DetachSoftwareSourcesFromProfileDetails(object):
    """
    Provides the information used to detach software sources from a profile.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DetachSoftwareSourcesFromProfileDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param software_sources:
            The value to assign to the software_sources property of this DetachSoftwareSourcesFromProfileDetails.
        :type software_sources: list[str]

        """
        self.swagger_types = {
            'software_sources': 'list[str]'
        }
        self.attribute_map = {
            'software_sources': 'softwareSources'
        }
        self._software_sources = None

    @property
    def software_sources(self):
        """
        **[Required]** Gets the software_sources of this DetachSoftwareSourcesFromProfileDetails.
        List of software source `OCIDs`__ to detach from the profile.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The software_sources of this DetachSoftwareSourcesFromProfileDetails.
        :rtype: list[str]
        """
        return self._software_sources

    @software_sources.setter
    def software_sources(self, software_sources):
        """
        Sets the software_sources of this DetachSoftwareSourcesFromProfileDetails.
        List of software source `OCIDs`__ to detach from the profile.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param software_sources: The software_sources of this DetachSoftwareSourcesFromProfileDetails.
        :type: list[str]
        """
        self._software_sources = software_sources

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
