# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePrivateServiceAccessDetails(object):
    """
    Details to create a private service access.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePrivateServiceAccessDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreatePrivateServiceAccessDetails.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreatePrivateServiceAccessDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreatePrivateServiceAccessDetails.
        :type freeform_tags: dict(str, str)

        :param security_attributes:
            The value to assign to the security_attributes property of this CreatePrivateServiceAccessDetails.
        :type security_attributes: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this CreatePrivateServiceAccessDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreatePrivateServiceAccessDetails.
        :type description: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreatePrivateServiceAccessDetails.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreatePrivateServiceAccessDetails.
        :type nsg_ids: list[str]

        :param service_id:
            The value to assign to the service_id property of this CreatePrivateServiceAccessDetails.
        :type service_id: str

        :param ipv4_ip:
            The value to assign to the ipv4_ip property of this CreatePrivateServiceAccessDetails.
        :type ipv4_ip: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'security_attributes': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'description': 'str',
            'subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'service_id': 'str',
            'ipv4_ip': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'security_attributes': 'securityAttributes',
            'display_name': 'displayName',
            'description': 'description',
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds',
            'service_id': 'serviceId',
            'ipv4_ip': 'ipv4Ip'
        }
        self._compartment_id = None
        self._defined_tags = None
        self._freeform_tags = None
        self._security_attributes = None
        self._display_name = None
        self._description = None
        self._subnet_id = None
        self._nsg_ids = None
        self._service_id = None
        self._ipv4_ip = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreatePrivateServiceAccessDetails.
        The `OCID`__ of the compartment to contain the
        private service access.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreatePrivateServiceAccessDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreatePrivateServiceAccessDetails.
        The `OCID`__ of the compartment to contain the
        private service access.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreatePrivateServiceAccessDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreatePrivateServiceAccessDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreatePrivateServiceAccessDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreatePrivateServiceAccessDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreatePrivateServiceAccessDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreatePrivateServiceAccessDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreatePrivateServiceAccessDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreatePrivateServiceAccessDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreatePrivateServiceAccessDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this CreatePrivateServiceAccessDetails.
        `Security attributes`__ are labels
        for a resource that can be referenced in a `Zero Trust Packet Routing`__
        (ZPR) policy to control access to ZPR-supported resources.

        Example: `{\"Oracle-DataSecurity-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes
        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm


        :return: The security_attributes of this CreatePrivateServiceAccessDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this CreatePrivateServiceAccessDetails.
        `Security attributes`__ are labels
        for a resource that can be referenced in a `Zero Trust Packet Routing`__
        (ZPR) policy to control access to ZPR-supported resources.

        Example: `{\"Oracle-DataSecurity-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes
        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm


        :param security_attributes: The security_attributes of this CreatePrivateServiceAccessDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def display_name(self):
        """
        Gets the display_name of this CreatePrivateServiceAccessDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreatePrivateServiceAccessDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreatePrivateServiceAccessDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreatePrivateServiceAccessDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreatePrivateServiceAccessDetails.
        A description of this private service accesss.


        :return: The description of this CreatePrivateServiceAccessDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreatePrivateServiceAccessDetails.
        A description of this private service accesss.


        :param description: The description of this CreatePrivateServiceAccessDetails.
        :type: str
        """
        self._description = description

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreatePrivateServiceAccessDetails.
        The `OCID`__ of the VCN's
        subnet where the private service access's VNIC will reside.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CreatePrivateServiceAccessDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreatePrivateServiceAccessDetails.
        The `OCID`__ of the VCN's
        subnet where the private service access's VNIC will reside.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CreatePrivateServiceAccessDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreatePrivateServiceAccessDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private
        service access's VNIC to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :return: The nsg_ids of this CreatePrivateServiceAccessDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreatePrivateServiceAccessDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private
        service access's VNIC to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :param nsg_ids: The nsg_ids of this CreatePrivateServiceAccessDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def service_id(self):
        """
        **[Required]** Gets the service_id of this CreatePrivateServiceAccessDetails.
        A unique service identifier for which the private service access was created.


        :return: The service_id of this CreatePrivateServiceAccessDetails.
        :rtype: str
        """
        return self._service_id

    @service_id.setter
    def service_id(self, service_id):
        """
        Sets the service_id of this CreatePrivateServiceAccessDetails.
        A unique service identifier for which the private service access was created.


        :param service_id: The service_id of this CreatePrivateServiceAccessDetails.
        :type: str
        """
        self._service_id = service_id

    @property
    def ipv4_ip(self):
        """
        Gets the ipv4_ip of this CreatePrivateServiceAccessDetails.
        The private IPv4 address (in the consumer's VCN) that represents the access point for the
        associated service.


        :return: The ipv4_ip of this CreatePrivateServiceAccessDetails.
        :rtype: str
        """
        return self._ipv4_ip

    @ipv4_ip.setter
    def ipv4_ip(self, ipv4_ip):
        """
        Sets the ipv4_ip of this CreatePrivateServiceAccessDetails.
        The private IPv4 address (in the consumer's VCN) that represents the access point for the
        associated service.


        :param ipv4_ip: The ipv4_ip of this CreatePrivateServiceAccessDetails.
        :type: str
        """
        self._ipv4_ip = ipv4_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
