# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SourceBackupDetails(object):
    """
    Information about the Source Backup associated with a backup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SourceBackupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_region:
            The value to assign to the source_region property of this SourceBackupDetails.
        :type source_region: str

        :param source_backup_id:
            The value to assign to the source_backup_id property of this SourceBackupDetails.
        :type source_backup_id: str

        """
        self.swagger_types = {
            'source_region': 'str',
            'source_backup_id': 'str'
        }
        self.attribute_map = {
            'source_region': 'sourceRegion',
            'source_backup_id': 'sourceBackupId'
        }
        self._source_region = None
        self._source_backup_id = None

    @property
    def source_region(self):
        """
        **[Required]** Gets the source_region of this SourceBackupDetails.
        Backup Region of the COPY source type.


        :return: The source_region of this SourceBackupDetails.
        :rtype: str
        """
        return self._source_region

    @source_region.setter
    def source_region(self, source_region):
        """
        Sets the source_region of this SourceBackupDetails.
        Backup Region of the COPY source type.


        :param source_region: The source_region of this SourceBackupDetails.
        :type: str
        """
        self._source_region = source_region

    @property
    def source_backup_id(self):
        """
        **[Required]** Gets the source_backup_id of this SourceBackupDetails.
        Backup ID of the COPY source type.


        :return: The source_backup_id of this SourceBackupDetails.
        :rtype: str
        """
        return self._source_backup_id

    @source_backup_id.setter
    def source_backup_id(self, source_backup_id):
        """
        Sets the source_backup_id of this SourceBackupDetails.
        Backup ID of the COPY source type.


        :param source_backup_id: The source_backup_id of this SourceBackupDetails.
        :type: str
        """
        self._source_backup_id = source_backup_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
