# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201

from .capability_details import CapabilityDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConsumerGroupsCapabilityDetails(CapabilityDetails):
    """
    Specifies the details for the consumer group capability.
    All fields are optional and are only used when the capability is added. Fields will be `null` when the capability is returned as part of the GetQueue API.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConsumerGroupsCapabilityDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.queue.models.ConsumerGroupsCapabilityDetails.type` attribute
        of this class is ``CONSUMER_GROUPS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ConsumerGroupsCapabilityDetails.
            Allowed values for this property are: "CONSUMER_GROUPS", "LARGE_MESSAGES"
        :type type: str

        :param is_primary_consumer_group_enabled:
            The value to assign to the is_primary_consumer_group_enabled property of this ConsumerGroupsCapabilityDetails.
        :type is_primary_consumer_group_enabled: bool

        :param primary_consumer_group_display_name:
            The value to assign to the primary_consumer_group_display_name property of this ConsumerGroupsCapabilityDetails.
        :type primary_consumer_group_display_name: str

        :param primary_consumer_group_filter:
            The value to assign to the primary_consumer_group_filter property of this ConsumerGroupsCapabilityDetails.
        :type primary_consumer_group_filter: str

        :param primary_consumer_group_dead_letter_queue_delivery_count:
            The value to assign to the primary_consumer_group_dead_letter_queue_delivery_count property of this ConsumerGroupsCapabilityDetails.
        :type primary_consumer_group_dead_letter_queue_delivery_count: int

        """
        self.swagger_types = {
            'type': 'str',
            'is_primary_consumer_group_enabled': 'bool',
            'primary_consumer_group_display_name': 'str',
            'primary_consumer_group_filter': 'str',
            'primary_consumer_group_dead_letter_queue_delivery_count': 'int'
        }
        self.attribute_map = {
            'type': 'type',
            'is_primary_consumer_group_enabled': 'isPrimaryConsumerGroupEnabled',
            'primary_consumer_group_display_name': 'primaryConsumerGroupDisplayName',
            'primary_consumer_group_filter': 'primaryConsumerGroupFilter',
            'primary_consumer_group_dead_letter_queue_delivery_count': 'primaryConsumerGroupDeadLetterQueueDeliveryCount'
        }
        self._type = None
        self._is_primary_consumer_group_enabled = None
        self._primary_consumer_group_display_name = None
        self._primary_consumer_group_filter = None
        self._primary_consumer_group_dead_letter_queue_delivery_count = None
        self._type = 'CONSUMER_GROUPS'

    @property
    def is_primary_consumer_group_enabled(self):
        """
        Gets the is_primary_consumer_group_enabled of this ConsumerGroupsCapabilityDetails.
        Specifies if the primary consumer group should be automatically enabled after adding the capability.


        :return: The is_primary_consumer_group_enabled of this ConsumerGroupsCapabilityDetails.
        :rtype: bool
        """
        return self._is_primary_consumer_group_enabled

    @is_primary_consumer_group_enabled.setter
    def is_primary_consumer_group_enabled(self, is_primary_consumer_group_enabled):
        """
        Sets the is_primary_consumer_group_enabled of this ConsumerGroupsCapabilityDetails.
        Specifies if the primary consumer group should be automatically enabled after adding the capability.


        :param is_primary_consumer_group_enabled: The is_primary_consumer_group_enabled of this ConsumerGroupsCapabilityDetails.
        :type: bool
        """
        self._is_primary_consumer_group_enabled = is_primary_consumer_group_enabled

    @property
    def primary_consumer_group_display_name(self):
        """
        Gets the primary_consumer_group_display_name of this ConsumerGroupsCapabilityDetails.
        Name of the primary consumer group. If omitted, it will be named \"Primary Consumer Group\".


        :return: The primary_consumer_group_display_name of this ConsumerGroupsCapabilityDetails.
        :rtype: str
        """
        return self._primary_consumer_group_display_name

    @primary_consumer_group_display_name.setter
    def primary_consumer_group_display_name(self, primary_consumer_group_display_name):
        """
        Sets the primary_consumer_group_display_name of this ConsumerGroupsCapabilityDetails.
        Name of the primary consumer group. If omitted, it will be named \"Primary Consumer Group\".


        :param primary_consumer_group_display_name: The primary_consumer_group_display_name of this ConsumerGroupsCapabilityDetails.
        :type: str
        """
        self._primary_consumer_group_display_name = primary_consumer_group_display_name

    @property
    def primary_consumer_group_filter(self):
        """
        Gets the primary_consumer_group_filter of this ConsumerGroupsCapabilityDetails.
        The filter used by the primary consumer group. Only messages matching the filter will be available by consumers of the group.
        An empty value means that all messages will be available in the group.


        :return: The primary_consumer_group_filter of this ConsumerGroupsCapabilityDetails.
        :rtype: str
        """
        return self._primary_consumer_group_filter

    @primary_consumer_group_filter.setter
    def primary_consumer_group_filter(self, primary_consumer_group_filter):
        """
        Sets the primary_consumer_group_filter of this ConsumerGroupsCapabilityDetails.
        The filter used by the primary consumer group. Only messages matching the filter will be available by consumers of the group.
        An empty value means that all messages will be available in the group.


        :param primary_consumer_group_filter: The primary_consumer_group_filter of this ConsumerGroupsCapabilityDetails.
        :type: str
        """
        self._primary_consumer_group_filter = primary_consumer_group_filter

    @property
    def primary_consumer_group_dead_letter_queue_delivery_count(self):
        """
        Gets the primary_consumer_group_dead_letter_queue_delivery_count of this ConsumerGroupsCapabilityDetails.
        The number of times a message can be delivered to a consumer before being moved to the dead letter queue.
        A value of 0 indicates that the DLQ is not used.
        If the value isn't set, it will be using the value defined at the queue level.


        :return: The primary_consumer_group_dead_letter_queue_delivery_count of this ConsumerGroupsCapabilityDetails.
        :rtype: int
        """
        return self._primary_consumer_group_dead_letter_queue_delivery_count

    @primary_consumer_group_dead_letter_queue_delivery_count.setter
    def primary_consumer_group_dead_letter_queue_delivery_count(self, primary_consumer_group_dead_letter_queue_delivery_count):
        """
        Sets the primary_consumer_group_dead_letter_queue_delivery_count of this ConsumerGroupsCapabilityDetails.
        The number of times a message can be delivered to a consumer before being moved to the dead letter queue.
        A value of 0 indicates that the DLQ is not used.
        If the value isn't set, it will be using the value defined at the queue level.


        :param primary_consumer_group_dead_letter_queue_delivery_count: The primary_consumer_group_dead_letter_queue_delivery_count of this ConsumerGroupsCapabilityDetails.
        :type: int
        """
        self._primary_consumer_group_dead_letter_queue_delivery_count = primary_consumer_group_dead_letter_queue_delivery_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
