# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateConsumerGroupDetails(object):
    """
    The information about a new consumer group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateConsumerGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateConsumerGroupDetails.
        :type display_name: str

        :param filter:
            The value to assign to the filter property of this CreateConsumerGroupDetails.
        :type filter: str

        :param queue_id:
            The value to assign to the queue_id property of this CreateConsumerGroupDetails.
        :type queue_id: str

        :param is_enabled:
            The value to assign to the is_enabled property of this CreateConsumerGroupDetails.
        :type is_enabled: bool

        :param dead_letter_queue_delivery_count:
            The value to assign to the dead_letter_queue_delivery_count property of this CreateConsumerGroupDetails.
        :type dead_letter_queue_delivery_count: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateConsumerGroupDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateConsumerGroupDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'filter': 'str',
            'queue_id': 'str',
            'is_enabled': 'bool',
            'dead_letter_queue_delivery_count': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'filter': 'filter',
            'queue_id': 'queueId',
            'is_enabled': 'isEnabled',
            'dead_letter_queue_delivery_count': 'deadLetterQueueDeliveryCount',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._filter = None
        self._queue_id = None
        self._is_enabled = None
        self._dead_letter_queue_delivery_count = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateConsumerGroupDetails.
        The user-friendly name of the consumer group.


        :return: The display_name of this CreateConsumerGroupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateConsumerGroupDetails.
        The user-friendly name of the consumer group.


        :param display_name: The display_name of this CreateConsumerGroupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def filter(self):
        """
        Gets the filter of this CreateConsumerGroupDetails.
        The filter used by the consumer group. Only messages matching the filter will be available by consumers of the group.


        :return: The filter of this CreateConsumerGroupDetails.
        :rtype: str
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """
        Sets the filter of this CreateConsumerGroupDetails.
        The filter used by the consumer group. Only messages matching the filter will be available by consumers of the group.


        :param filter: The filter of this CreateConsumerGroupDetails.
        :type: str
        """
        self._filter = filter

    @property
    def queue_id(self):
        """
        **[Required]** Gets the queue_id of this CreateConsumerGroupDetails.
        The OCID of the associated queue.


        :return: The queue_id of this CreateConsumerGroupDetails.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id):
        """
        Sets the queue_id of this CreateConsumerGroupDetails.
        The OCID of the associated queue.


        :param queue_id: The queue_id of this CreateConsumerGroupDetails.
        :type: str
        """
        self._queue_id = queue_id

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this CreateConsumerGroupDetails.
        Used to enable or disable the consumer group.
        An enabled consumer group will have a lifecycle state of ACTIVE, while a disabled will have its state as INACTIVE.


        :return: The is_enabled of this CreateConsumerGroupDetails.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this CreateConsumerGroupDetails.
        Used to enable or disable the consumer group.
        An enabled consumer group will have a lifecycle state of ACTIVE, while a disabled will have its state as INACTIVE.


        :param is_enabled: The is_enabled of this CreateConsumerGroupDetails.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def dead_letter_queue_delivery_count(self):
        """
        Gets the dead_letter_queue_delivery_count of this CreateConsumerGroupDetails.
        The number of times a message can be delivered to a consumer before being moved to the dead letter queue.
        A value of 0 indicates that the DLQ is not used.
        If the value isn't specified, it will be using the value defined at the queue level.


        :return: The dead_letter_queue_delivery_count of this CreateConsumerGroupDetails.
        :rtype: int
        """
        return self._dead_letter_queue_delivery_count

    @dead_letter_queue_delivery_count.setter
    def dead_letter_queue_delivery_count(self, dead_letter_queue_delivery_count):
        """
        Sets the dead_letter_queue_delivery_count of this CreateConsumerGroupDetails.
        The number of times a message can be delivered to a consumer before being moved to the dead letter queue.
        A value of 0 indicates that the DLQ is not used.
        If the value isn't specified, it will be using the value defined at the queue level.


        :param dead_letter_queue_delivery_count: The dead_letter_queue_delivery_count of this CreateConsumerGroupDetails.
        :type: int
        """
        self._dead_letter_queue_delivery_count = dead_letter_queue_delivery_count

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateConsumerGroupDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateConsumerGroupDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateConsumerGroupDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateConsumerGroupDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateConsumerGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateConsumerGroupDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateConsumerGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateConsumerGroupDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
