# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigurationInfo(object):
    """
    Details of a configuration setting in the OCI Cache Config Set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigurationInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_key:
            The value to assign to the config_key property of this ConfigurationInfo.
        :type config_key: str

        :param config_value:
            The value to assign to the config_value property of this ConfigurationInfo.
        :type config_value: str

        """
        self.swagger_types = {
            'config_key': 'str',
            'config_value': 'str'
        }
        self.attribute_map = {
            'config_key': 'configKey',
            'config_value': 'configValue'
        }
        self._config_key = None
        self._config_value = None

    @property
    def config_key(self):
        """
        **[Required]** Gets the config_key of this ConfigurationInfo.
        Key is the configuration key.


        :return: The config_key of this ConfigurationInfo.
        :rtype: str
        """
        return self._config_key

    @config_key.setter
    def config_key(self, config_key):
        """
        Sets the config_key of this ConfigurationInfo.
        Key is the configuration key.


        :param config_key: The config_key of this ConfigurationInfo.
        :type: str
        """
        self._config_key = config_key

    @property
    def config_value(self):
        """
        **[Required]** Gets the config_value of this ConfigurationInfo.
        Value of the configuration as a string. Can represent a string, boolean, or number.
        Example: \"true\", \"42\", or \"someString\".


        :return: The config_value of this ConfigurationInfo.
        :rtype: str
        """
        return self._config_value

    @config_value.setter
    def config_value(self, config_value):
        """
        Sets the config_value of this ConfigurationInfo.
        Value of the configuration as a string. Can represent a string, boolean, or number.
        Example: \"true\", \"42\", or \"someString\".


        :param config_value: The config_value of this ConfigurationInfo.
        :type: str
        """
        self._config_value = config_value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
