# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciCacheUser(object):
    """
    An OCI cache user is required to connect to an OCI cache cluster.
    """

    #: A constant which can be used with the status property of a OciCacheUser.
    #: This constant has a value of "ON"
    STATUS_ON = "ON"

    #: A constant which can be used with the status property of a OciCacheUser.
    #: This constant has a value of "OFF"
    STATUS_OFF = "OFF"

    #: A constant which can be used with the lifecycle_state property of a OciCacheUser.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a OciCacheUser.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a OciCacheUser.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OciCacheUser.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a OciCacheUser.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a OciCacheUser.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new OciCacheUser object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OciCacheUser.
        :type id: str

        :param name:
            The value to assign to the name property of this OciCacheUser.
        :type name: str

        :param description:
            The value to assign to the description property of this OciCacheUser.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OciCacheUser.
        :type compartment_id: str

        :param authentication_mode:
            The value to assign to the authentication_mode property of this OciCacheUser.
        :type authentication_mode: oci.redis.models.AuthenticationMode

        :param acl_string:
            The value to assign to the acl_string property of this OciCacheUser.
        :type acl_string: str

        :param status:
            The value to assign to the status property of this OciCacheUser.
            Allowed values for this property are: "ON", "OFF", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OciCacheUser.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this OciCacheUser.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OciCacheUser.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OciCacheUser.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OciCacheUser.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OciCacheUser.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'authentication_mode': 'AuthenticationMode',
            'acl_string': 'str',
            'status': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'authentication_mode': 'authenticationMode',
            'acl_string': 'aclString',
            'status': 'status',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._name = None
        self._description = None
        self._compartment_id = None
        self._authentication_mode = None
        self._acl_string = None
        self._status = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OciCacheUser.
        OCI Cache user unique ID.


        :return: The id of this OciCacheUser.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OciCacheUser.
        OCI Cache user unique ID.


        :param id: The id of this OciCacheUser.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this OciCacheUser.
        OCI Cache user name.


        :return: The name of this OciCacheUser.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OciCacheUser.
        OCI Cache user name.


        :param name: The name of this OciCacheUser.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this OciCacheUser.
        Description of OCI cache user.


        :return: The description of this OciCacheUser.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this OciCacheUser.
        Description of OCI cache user.


        :param description: The description of this OciCacheUser.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OciCacheUser.
        OCI Cache user compartment ID.


        :return: The compartment_id of this OciCacheUser.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OciCacheUser.
        OCI Cache user compartment ID.


        :param compartment_id: The compartment_id of this OciCacheUser.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def authentication_mode(self):
        """
        **[Required]** Gets the authentication_mode of this OciCacheUser.

        :return: The authentication_mode of this OciCacheUser.
        :rtype: oci.redis.models.AuthenticationMode
        """
        return self._authentication_mode

    @authentication_mode.setter
    def authentication_mode(self, authentication_mode):
        """
        Sets the authentication_mode of this OciCacheUser.

        :param authentication_mode: The authentication_mode of this OciCacheUser.
        :type: oci.redis.models.AuthenticationMode
        """
        self._authentication_mode = authentication_mode

    @property
    def acl_string(self):
        """
        **[Required]** Gets the acl_string of this OciCacheUser.
        ACL string of OCI cache user.


        :return: The acl_string of this OciCacheUser.
        :rtype: str
        """
        return self._acl_string

    @acl_string.setter
    def acl_string(self, acl_string):
        """
        Sets the acl_string of this OciCacheUser.
        ACL string of OCI cache user.


        :param acl_string: The acl_string of this OciCacheUser.
        :type: str
        """
        self._acl_string = acl_string

    @property
    def status(self):
        """
        **[Required]** Gets the status of this OciCacheUser.
        OCI Cache user status. ON enables and OFF disables the OCI cache user to login to the cluster.

        Allowed values for this property are: "ON", "OFF", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this OciCacheUser.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this OciCacheUser.
        OCI Cache user status. ON enables and OFF disables the OCI cache user to login to the cluster.


        :param status: The status of this OciCacheUser.
        :type: str
        """
        allowed_values = ["ON", "OFF"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this OciCacheUser.
        OCI Cache user lifecycle state.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this OciCacheUser.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OciCacheUser.
        OCI Cache user lifecycle state.


        :param lifecycle_state: The lifecycle_state of this OciCacheUser.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this OciCacheUser.
        The date and time, when the OCI cache user was created.


        :return: The time_created of this OciCacheUser.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OciCacheUser.
        The date and time, when the OCI cache user was created.


        :param time_created: The time_created of this OciCacheUser.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OciCacheUser.
        The date and time, when the OCI cache user was updated.


        :return: The time_updated of this OciCacheUser.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OciCacheUser.
        The date and time, when the OCI cache user was updated.


        :param time_updated: The time_updated of this OciCacheUser.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OciCacheUser.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this OciCacheUser.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OciCacheUser.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this OciCacheUser.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OciCacheUser.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this OciCacheUser.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OciCacheUser.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this OciCacheUser.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OciCacheUser.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OciCacheUser.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OciCacheUser.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OciCacheUser.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
