# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciCacheUserSummary(object):
    """
    OCI Cache user summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciCacheUserSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OciCacheUserSummary.
        :type id: str

        :param name:
            The value to assign to the name property of this OciCacheUserSummary.
        :type name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OciCacheUserSummary.
        :type compartment_id: str

        :param authentication_type:
            The value to assign to the authentication_type property of this OciCacheUserSummary.
        :type authentication_type: str

        :param status:
            The value to assign to the status property of this OciCacheUserSummary.
        :type status: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OciCacheUserSummary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this OciCacheUserSummary.
        :type time_created: datetime

        :param description:
            The value to assign to the description property of this OciCacheUserSummary.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OciCacheUserSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OciCacheUserSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OciCacheUserSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'compartment_id': 'str',
            'authentication_type': 'str',
            'status': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'compartment_id': 'compartmentId',
            'authentication_type': 'authenticationType',
            'status': 'status',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._name = None
        self._compartment_id = None
        self._authentication_type = None
        self._status = None
        self._lifecycle_state = None
        self._time_created = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OciCacheUserSummary.
        OCI Cache user unique ID.


        :return: The id of this OciCacheUserSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OciCacheUserSummary.
        OCI Cache user unique ID.


        :param id: The id of this OciCacheUserSummary.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this OciCacheUserSummary.
        OCI Cache user name.


        :return: The name of this OciCacheUserSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OciCacheUserSummary.
        OCI Cache user name.


        :param name: The name of this OciCacheUserSummary.
        :type: str
        """
        self._name = name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OciCacheUserSummary.
        OCI Cache user compartment ID.


        :return: The compartment_id of this OciCacheUserSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OciCacheUserSummary.
        OCI Cache user compartment ID.


        :param compartment_id: The compartment_id of this OciCacheUserSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def authentication_type(self):
        """
        **[Required]** Gets the authentication_type of this OciCacheUserSummary.
        OCI Cache user authentication type.


        :return: The authentication_type of this OciCacheUserSummary.
        :rtype: str
        """
        return self._authentication_type

    @authentication_type.setter
    def authentication_type(self, authentication_type):
        """
        Sets the authentication_type of this OciCacheUserSummary.
        OCI Cache user authentication type.


        :param authentication_type: The authentication_type of this OciCacheUserSummary.
        :type: str
        """
        self._authentication_type = authentication_type

    @property
    def status(self):
        """
        **[Required]** Gets the status of this OciCacheUserSummary.
        OCI Cache user status. ON enables and OFF disables the OCI cache user to use the cluster.


        :return: The status of this OciCacheUserSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this OciCacheUserSummary.
        OCI Cache user status. ON enables and OFF disables the OCI cache user to use the cluster.


        :param status: The status of this OciCacheUserSummary.
        :type: str
        """
        self._status = status

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this OciCacheUserSummary.
        OCI Cache user lifecycle state.


        :return: The lifecycle_state of this OciCacheUserSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OciCacheUserSummary.
        OCI Cache user lifecycle state.


        :param lifecycle_state: The lifecycle_state of this OciCacheUserSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this OciCacheUserSummary.
        The date and time, when the OCI cache user was created.


        :return: The time_created of this OciCacheUserSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OciCacheUserSummary.
        The date and time, when the OCI cache user was created.


        :param time_created: The time_created of this OciCacheUserSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def description(self):
        """
        **[Required]** Gets the description of this OciCacheUserSummary.
        Description of OCI cache user.


        :return: The description of this OciCacheUserSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this OciCacheUserSummary.
        Description of OCI cache user.


        :param description: The description of this OciCacheUserSummary.
        :type: str
        """
        self._description = description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OciCacheUserSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this OciCacheUserSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OciCacheUserSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this OciCacheUserSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OciCacheUserSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this OciCacheUserSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OciCacheUserSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this OciCacheUserSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OciCacheUserSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OciCacheUserSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OciCacheUserSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OciCacheUserSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
