# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceFilter(object):
    """
    This is a generic filter used to decide which resources that the schedule be applied to.
    """

    #: A constant which can be used with the attribute property of a ResourceFilter.
    #: This constant has a value of "COMPARTMENT_ID"
    ATTRIBUTE_COMPARTMENT_ID = "COMPARTMENT_ID"

    #: A constant which can be used with the attribute property of a ResourceFilter.
    #: This constant has a value of "RESOURCE_TYPE"
    ATTRIBUTE_RESOURCE_TYPE = "RESOURCE_TYPE"

    #: A constant which can be used with the attribute property of a ResourceFilter.
    #: This constant has a value of "DEFINED_TAGS"
    ATTRIBUTE_DEFINED_TAGS = "DEFINED_TAGS"

    #: A constant which can be used with the attribute property of a ResourceFilter.
    #: This constant has a value of "TIME_CREATED"
    ATTRIBUTE_TIME_CREATED = "TIME_CREATED"

    #: A constant which can be used with the attribute property of a ResourceFilter.
    #: This constant has a value of "LIFECYCLE_STATE"
    ATTRIBUTE_LIFECYCLE_STATE = "LIFECYCLE_STATE"

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceFilter object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.resource_scheduler.models.TimeCreatedResourceFilter`
        * :class:`~oci.resource_scheduler.models.ResourceTypeResourceFilter`
        * :class:`~oci.resource_scheduler.models.LifecycleStateResourceFilter`
        * :class:`~oci.resource_scheduler.models.CompartmentIdResourceFilter`
        * :class:`~oci.resource_scheduler.models.DefinedTagsResourceFilter`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute:
            The value to assign to the attribute property of this ResourceFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "RESOURCE_TYPE", "DEFINED_TAGS", "TIME_CREATED", "LIFECYCLE_STATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type attribute: str

        """
        self.swagger_types = {
            'attribute': 'str'
        }
        self.attribute_map = {
            'attribute': 'attribute'
        }
        self._attribute = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['attribute']

        if type == 'TIME_CREATED':
            return 'TimeCreatedResourceFilter'

        if type == 'RESOURCE_TYPE':
            return 'ResourceTypeResourceFilter'

        if type == 'LIFECYCLE_STATE':
            return 'LifecycleStateResourceFilter'

        if type == 'COMPARTMENT_ID':
            return 'CompartmentIdResourceFilter'

        if type == 'DEFINED_TAGS':
            return 'DefinedTagsResourceFilter'
        else:
            return 'ResourceFilter'

    @property
    def attribute(self):
        """
        **[Required]** Gets the attribute of this ResourceFilter.
        This is the resource attribute on which the threshold is defined.

        Allowed values for this property are: "COMPARTMENT_ID", "RESOURCE_TYPE", "DEFINED_TAGS", "TIME_CREATED", "LIFECYCLE_STATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The attribute of this ResourceFilter.
        :rtype: str
        """
        return self._attribute

    @attribute.setter
    def attribute(self, attribute):
        """
        Sets the attribute of this ResourceFilter.
        This is the resource attribute on which the threshold is defined.


        :param attribute: The attribute of this ResourceFilter.
        :type: str
        """
        allowed_values = ["COMPARTMENT_ID", "RESOURCE_TYPE", "DEFINED_TAGS", "TIME_CREATED", "LIFECYCLE_STATE"]
        if not value_allowed_none_or_none_sentinel(attribute, allowed_values):
            attribute = 'UNKNOWN_ENUM_VALUE'
        self._attribute = attribute

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
