# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240815

from .base_security_attribute_validator import BaseSecurityAttributeValidator
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EnumSecurityAttributeValidator(BaseSecurityAttributeValidator):
    """
    Used to validate the value set for a security attribute and contains the list of allowable `values`.

    You must specify at least one valid value in the `values` array. You can't have blank or
    or empty strings (`\"\"`). Duplicate values are not allowed.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EnumSecurityAttributeValidator object with values from keyword arguments. The default value of the :py:attr:`~oci.security_attribute.models.EnumSecurityAttributeValidator.validator_type` attribute
        of this class is ``ENUM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param validator_type:
            The value to assign to the validator_type property of this EnumSecurityAttributeValidator.
            Allowed values for this property are: "ENUM", "DEFAULT"
        :type validator_type: str

        :param values:
            The value to assign to the values property of this EnumSecurityAttributeValidator.
        :type values: list[str]

        """
        self.swagger_types = {
            'validator_type': 'str',
            'values': 'list[str]'
        }
        self.attribute_map = {
            'validator_type': 'validatorType',
            'values': 'values'
        }
        self._validator_type = None
        self._values = None
        self._validator_type = 'ENUM'

    @property
    def values(self):
        """
        Gets the values of this EnumSecurityAttributeValidator.
        The list of allowed values for a security attribute value.


        :return: The values of this EnumSecurityAttributeValidator.
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this EnumSecurityAttributeValidator.
        The list of allowed values for a security attribute value.


        :param values: The values of this EnumSecurityAttributeValidator.
        :type: list[str]
        """
        self._values = values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
