# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .maintenance_window_schedule import MaintenanceWindowSchedule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecurrentMaintenanceWindowSchedule(MaintenanceWindowSchedule):
    """
    Schedule information for the Maintenance Window that is executed multiple times.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RecurrentMaintenanceWindowSchedule object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.RecurrentMaintenanceWindowSchedule.schedule_type` attribute
        of this class is ``RECURRENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schedule_type:
            The value to assign to the schedule_type property of this RecurrentMaintenanceWindowSchedule.
            Allowed values for this property are: "ONE_TIME", "RECURRENT"
        :type schedule_type: str

        :param time_maintenance_window_start:
            The value to assign to the time_maintenance_window_start property of this RecurrentMaintenanceWindowSchedule.
        :type time_maintenance_window_start: datetime

        :param time_maintenance_window_end:
            The value to assign to the time_maintenance_window_end property of this RecurrentMaintenanceWindowSchedule.
        :type time_maintenance_window_end: datetime

        :param maintenance_window_recurrences:
            The value to assign to the maintenance_window_recurrences property of this RecurrentMaintenanceWindowSchedule.
        :type maintenance_window_recurrences: str

        :param maintenance_window_duration:
            The value to assign to the maintenance_window_duration property of this RecurrentMaintenanceWindowSchedule.
        :type maintenance_window_duration: str

        """
        self.swagger_types = {
            'schedule_type': 'str',
            'time_maintenance_window_start': 'datetime',
            'time_maintenance_window_end': 'datetime',
            'maintenance_window_recurrences': 'str',
            'maintenance_window_duration': 'str'
        }
        self.attribute_map = {
            'schedule_type': 'scheduleType',
            'time_maintenance_window_start': 'timeMaintenanceWindowStart',
            'time_maintenance_window_end': 'timeMaintenanceWindowEnd',
            'maintenance_window_recurrences': 'maintenanceWindowRecurrences',
            'maintenance_window_duration': 'maintenanceWindowDuration'
        }
        self._schedule_type = None
        self._time_maintenance_window_start = None
        self._time_maintenance_window_end = None
        self._maintenance_window_recurrences = None
        self._maintenance_window_duration = None
        self._schedule_type = 'RECURRENT'

    @property
    def time_maintenance_window_start(self):
        """
        Gets the time_maintenance_window_start of this RecurrentMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :return: The time_maintenance_window_start of this RecurrentMaintenanceWindowSchedule.
        :rtype: datetime
        """
        return self._time_maintenance_window_start

    @time_maintenance_window_start.setter
    def time_maintenance_window_start(self, time_maintenance_window_start):
        """
        Sets the time_maintenance_window_start of this RecurrentMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :param time_maintenance_window_start: The time_maintenance_window_start of this RecurrentMaintenanceWindowSchedule.
        :type: datetime
        """
        self._time_maintenance_window_start = time_maintenance_window_start

    @property
    def time_maintenance_window_end(self):
        """
        Gets the time_maintenance_window_end of this RecurrentMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :return: The time_maintenance_window_end of this RecurrentMaintenanceWindowSchedule.
        :rtype: datetime
        """
        return self._time_maintenance_window_end

    @time_maintenance_window_end.setter
    def time_maintenance_window_end(self, time_maintenance_window_end):
        """
        Sets the time_maintenance_window_end of this RecurrentMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :param time_maintenance_window_end: The time_maintenance_window_end of this RecurrentMaintenanceWindowSchedule.
        :type: datetime
        """
        self._time_maintenance_window_end = time_maintenance_window_end

    @property
    def maintenance_window_recurrences(self):
        """
        **[Required]** Gets the maintenance_window_recurrences of this RecurrentMaintenanceWindowSchedule.
        A RFC5545 formatted recurrence string which represents the Maintenance Window Recurrence.
        Please refer this for details:https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10
        FREQ: Frequency of the Maintenance Window. The supported values are: DAILY and WEEKLY.
        BYDAY: Comma separated days for Weekly Maintenance Window.
        BYHOUR: Specifies the start hour of each recurrence after `timeMaintenanceWindowStart` value.
        BYMINUTE: Specifies the start minute of each reccurrence after `timeMaintenanceWindowStart` value. The default value is 00
        BYSECOND: Specifies the start second of each reccurrence after `timeMaintenanceWindowStart` value. The default value is 00
        Other Rules are not supported.


        :return: The maintenance_window_recurrences of this RecurrentMaintenanceWindowSchedule.
        :rtype: str
        """
        return self._maintenance_window_recurrences

    @maintenance_window_recurrences.setter
    def maintenance_window_recurrences(self, maintenance_window_recurrences):
        """
        Sets the maintenance_window_recurrences of this RecurrentMaintenanceWindowSchedule.
        A RFC5545 formatted recurrence string which represents the Maintenance Window Recurrence.
        Please refer this for details:https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10
        FREQ: Frequency of the Maintenance Window. The supported values are: DAILY and WEEKLY.
        BYDAY: Comma separated days for Weekly Maintenance Window.
        BYHOUR: Specifies the start hour of each recurrence after `timeMaintenanceWindowStart` value.
        BYMINUTE: Specifies the start minute of each reccurrence after `timeMaintenanceWindowStart` value. The default value is 00
        BYSECOND: Specifies the start second of each reccurrence after `timeMaintenanceWindowStart` value. The default value is 00
        Other Rules are not supported.


        :param maintenance_window_recurrences: The maintenance_window_recurrences of this RecurrentMaintenanceWindowSchedule.
        :type: str
        """
        self._maintenance_window_recurrences = maintenance_window_recurrences

    @property
    def maintenance_window_duration(self):
        """
        Gets the maintenance_window_duration of this RecurrentMaintenanceWindowSchedule.
        Duration time of each recurrence of each Maintenance Window.
        It must be specified as a string in ISO 8601 extended format.


        :return: The maintenance_window_duration of this RecurrentMaintenanceWindowSchedule.
        :rtype: str
        """
        return self._maintenance_window_duration

    @maintenance_window_duration.setter
    def maintenance_window_duration(self, maintenance_window_duration):
        """
        Sets the maintenance_window_duration of this RecurrentMaintenanceWindowSchedule.
        Duration time of each recurrence of each Maintenance Window.
        It must be specified as a string in ISO 8601 extended format.


        :param maintenance_window_duration: The maintenance_window_duration of this RecurrentMaintenanceWindowSchedule.
        :type: str
        """
        self._maintenance_window_duration = maintenance_window_duration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
