# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequestSummarizedMetricExtensionsMetricsDetails(object):
    """
    Filtering criteria data to be specified in the request. Either metricExtensionId or compartmentId must be passed even when no other filter property is passed.
    """

    #: A constant which can be used with the sort_by property of a RequestSummarizedMetricExtensionsMetricsDetails.
    #: This constant has a value of "COUNT"
    SORT_BY_COUNT = "COUNT"

    #: A constant which can be used with the sort_order property of a RequestSummarizedMetricExtensionsMetricsDetails.
    #: This constant has a value of "ASC"
    SORT_ORDER_ASC = "ASC"

    #: A constant which can be used with the sort_order property of a RequestSummarizedMetricExtensionsMetricsDetails.
    #: This constant has a value of "DESC"
    SORT_ORDER_DESC = "DESC"

    def __init__(self, **kwargs):
        """
        Initializes a new RequestSummarizedMetricExtensionsMetricsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_extension_id:
            The value to assign to the metric_extension_id property of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type metric_extension_id: str

        :param resource_type:
            The value to assign to the resource_type property of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type resource_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type compartment_id: str

        :param contains_metric_with_name:
            The value to assign to the contains_metric_with_name property of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type contains_metric_with_name: str

        :param sort_by:
            The value to assign to the sort_by property of this RequestSummarizedMetricExtensionsMetricsDetails.
            Allowed values for this property are: "COUNT"
        :type sort_by: str

        :param sort_order:
            The value to assign to the sort_order property of this RequestSummarizedMetricExtensionsMetricsDetails.
            Allowed values for this property are: "ASC", "DESC"
        :type sort_order: str

        """
        self.swagger_types = {
            'metric_extension_id': 'str',
            'resource_type': 'str',
            'compartment_id': 'str',
            'contains_metric_with_name': 'str',
            'sort_by': 'str',
            'sort_order': 'str'
        }
        self.attribute_map = {
            'metric_extension_id': 'metricExtensionId',
            'resource_type': 'resourceType',
            'compartment_id': 'compartmentId',
            'contains_metric_with_name': 'containsMetricWithName',
            'sort_by': 'sortBy',
            'sort_order': 'sortOrder'
        }
        self._metric_extension_id = None
        self._resource_type = None
        self._compartment_id = None
        self._contains_metric_with_name = None
        self._sort_by = None
        self._sort_order = None

    @property
    def metric_extension_id(self):
        """
        Gets the metric_extension_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        The `OCID`__ of Metric Extension resource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The metric_extension_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        :rtype: str
        """
        return self._metric_extension_id

    @metric_extension_id.setter
    def metric_extension_id(self, metric_extension_id):
        """
        Sets the metric_extension_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        The `OCID`__ of Metric Extension resource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param metric_extension_id: The metric_extension_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type: str
        """
        self._metric_extension_id = metric_extension_id

    @property
    def resource_type(self):
        """
        Gets the resource_type of this RequestSummarizedMetricExtensionsMetricsDetails.
        Resource type to which Metric Extension applies


        :return: The resource_type of this RequestSummarizedMetricExtensionsMetricsDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this RequestSummarizedMetricExtensionsMetricsDetails.
        Resource type to which Metric Extension applies


        :param resource_type: The resource_type of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        Compartment Identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        Compartment Identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def contains_metric_with_name(self):
        """
        Gets the contains_metric_with_name of this RequestSummarizedMetricExtensionsMetricsDetails.
        Filter for metric extension resources which contain the given metric name


        :return: The contains_metric_with_name of this RequestSummarizedMetricExtensionsMetricsDetails.
        :rtype: str
        """
        return self._contains_metric_with_name

    @contains_metric_with_name.setter
    def contains_metric_with_name(self, contains_metric_with_name):
        """
        Sets the contains_metric_with_name of this RequestSummarizedMetricExtensionsMetricsDetails.
        Filter for metric extension resources which contain the given metric name


        :param contains_metric_with_name: The contains_metric_with_name of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type: str
        """
        self._contains_metric_with_name = contains_metric_with_name

    @property
    def sort_by(self):
        """
        Gets the sort_by of this RequestSummarizedMetricExtensionsMetricsDetails.
        Result will ne sorted by this parameter value

        Allowed values for this property are: "COUNT"


        :return: The sort_by of this RequestSummarizedMetricExtensionsMetricsDetails.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """
        Sets the sort_by of this RequestSummarizedMetricExtensionsMetricsDetails.
        Result will ne sorted by this parameter value


        :param sort_by: The sort_by of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type: str
        """
        allowed_values = ["COUNT"]
        if not value_allowed_none_or_none_sentinel(sort_by, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_by`, must be None or one of {allowed_values}"
            )
        self._sort_by = sort_by

    @property
    def sort_order(self):
        """
        Gets the sort_order of this RequestSummarizedMetricExtensionsMetricsDetails.
        Sort orders

        Allowed values for this property are: "ASC", "DESC"


        :return: The sort_order of this RequestSummarizedMetricExtensionsMetricsDetails.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """
        Sets the sort_order of this RequestSummarizedMetricExtensionsMetricsDetails.
        Sort orders


        :param sort_order: The sort_order of this RequestSummarizedMetricExtensionsMetricsDetails.
        :type: str
        """
        allowed_values = ["ASC", "DESC"]
        if not value_allowed_none_or_none_sentinel(sort_order, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_order`, must be None or one of {allowed_values}"
            )
        self._sort_order = sort_order

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
