# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .monitored_resource_task_details import MonitoredResourceTaskDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAgentReceiverTaskDetails(MonitoredResourceTaskDetails):
    """
    Request details for enabling/disabling the metric receiver on the management agent.
    """

    #: A constant which can be used with the handler_type property of a UpdateAgentReceiverTaskDetails.
    #: This constant has a value of "TELEGRAF"
    HANDLER_TYPE_TELEGRAF = "TELEGRAF"

    #: A constant which can be used with the handler_type property of a UpdateAgentReceiverTaskDetails.
    #: This constant has a value of "COLLECTD"
    HANDLER_TYPE_COLLECTD = "COLLECTD"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAgentReceiverTaskDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.UpdateAgentReceiverTaskDetails.type` attribute
        of this class is ``UPDATE_AGENT_RECEIVER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this UpdateAgentReceiverTaskDetails.
            Allowed values for this property are: "IMPORT_OCI_TELEMETRY_RESOURCES", "UPDATE_AGENT_RECEIVER", "UPDATE_RESOURCE_TYPE_CONFIGS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param agent_id:
            The value to assign to the agent_id property of this UpdateAgentReceiverTaskDetails.
        :type agent_id: str

        :param handler_type:
            The value to assign to the handler_type property of this UpdateAgentReceiverTaskDetails.
            Allowed values for this property are: "TELEGRAF", "COLLECTD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type handler_type: str

        :param is_enable:
            The value to assign to the is_enable property of this UpdateAgentReceiverTaskDetails.
        :type is_enable: bool

        :param receiver_properties:
            The value to assign to the receiver_properties property of this UpdateAgentReceiverTaskDetails.
        :type receiver_properties: oci.stack_monitoring.models.AgentReceiverProperties

        """
        self.swagger_types = {
            'type': 'str',
            'agent_id': 'str',
            'handler_type': 'str',
            'is_enable': 'bool',
            'receiver_properties': 'AgentReceiverProperties'
        }
        self.attribute_map = {
            'type': 'type',
            'agent_id': 'agentId',
            'handler_type': 'handlerType',
            'is_enable': 'isEnable',
            'receiver_properties': 'receiverProperties'
        }
        self._type = None
        self._agent_id = None
        self._handler_type = None
        self._is_enable = None
        self._receiver_properties = None
        self._type = 'UPDATE_AGENT_RECEIVER'

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this UpdateAgentReceiverTaskDetails.
        Management Agent Identifier `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The agent_id of this UpdateAgentReceiverTaskDetails.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this UpdateAgentReceiverTaskDetails.
        Management Agent Identifier `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param agent_id: The agent_id of this UpdateAgentReceiverTaskDetails.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def handler_type(self):
        """
        **[Required]** Gets the handler_type of this UpdateAgentReceiverTaskDetails.
        Type of the handler.

        Allowed values for this property are: "TELEGRAF", "COLLECTD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The handler_type of this UpdateAgentReceiverTaskDetails.
        :rtype: str
        """
        return self._handler_type

    @handler_type.setter
    def handler_type(self, handler_type):
        """
        Sets the handler_type of this UpdateAgentReceiverTaskDetails.
        Type of the handler.


        :param handler_type: The handler_type of this UpdateAgentReceiverTaskDetails.
        :type: str
        """
        allowed_values = ["TELEGRAF", "COLLECTD"]
        if not value_allowed_none_or_none_sentinel(handler_type, allowed_values):
            handler_type = 'UNKNOWN_ENUM_VALUE'
        self._handler_type = handler_type

    @property
    def is_enable(self):
        """
        **[Required]** Gets the is_enable of this UpdateAgentReceiverTaskDetails.
        True to enable the receiver and false to disable the receiver on the agent.


        :return: The is_enable of this UpdateAgentReceiverTaskDetails.
        :rtype: bool
        """
        return self._is_enable

    @is_enable.setter
    def is_enable(self, is_enable):
        """
        Sets the is_enable of this UpdateAgentReceiverTaskDetails.
        True to enable the receiver and false to disable the receiver on the agent.


        :param is_enable: The is_enable of this UpdateAgentReceiverTaskDetails.
        :type: bool
        """
        self._is_enable = is_enable

    @property
    def receiver_properties(self):
        """
        Gets the receiver_properties of this UpdateAgentReceiverTaskDetails.

        :return: The receiver_properties of this UpdateAgentReceiverTaskDetails.
        :rtype: oci.stack_monitoring.models.AgentReceiverProperties
        """
        return self._receiver_properties

    @receiver_properties.setter
    def receiver_properties(self, receiver_properties):
        """
        Sets the receiver_properties of this UpdateAgentReceiverTaskDetails.

        :param receiver_properties: The receiver_properties of this UpdateAgentReceiverTaskDetails.
        :type: oci.stack_monitoring.models.AgentReceiverProperties
        """
        self._receiver_properties = receiver_properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
