# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180608


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplicationConfig(object):
    """
    Defines the configuration that enables cross-region secret replication.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReplicationConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param replication_targets:
            The value to assign to the replication_targets property of this ReplicationConfig.
        :type replication_targets: list[oci.vault.models.ReplicationTarget]

        :param is_write_forward_enabled:
            The value to assign to the is_write_forward_enabled property of this ReplicationConfig.
        :type is_write_forward_enabled: bool

        """
        self.swagger_types = {
            'replication_targets': 'list[ReplicationTarget]',
            'is_write_forward_enabled': 'bool'
        }
        self.attribute_map = {
            'replication_targets': 'replicationTargets',
            'is_write_forward_enabled': 'isWriteForwardEnabled'
        }
        self._replication_targets = None
        self._is_write_forward_enabled = None

    @property
    def replication_targets(self):
        """
        **[Required]** Gets the replication_targets of this ReplicationConfig.
        List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.


        :return: The replication_targets of this ReplicationConfig.
        :rtype: list[oci.vault.models.ReplicationTarget]
        """
        return self._replication_targets

    @replication_targets.setter
    def replication_targets(self, replication_targets):
        """
        Sets the replication_targets of this ReplicationConfig.
        List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.


        :param replication_targets: The replication_targets of this ReplicationConfig.
        :type: list[oci.vault.models.ReplicationTarget]
        """
        self._replication_targets = replication_targets

    @property
    def is_write_forward_enabled(self):
        """
        Gets the is_write_forward_enabled of this ReplicationConfig.
        (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.


        :return: The is_write_forward_enabled of this ReplicationConfig.
        :rtype: bool
        """
        return self._is_write_forward_enabled

    @is_write_forward_enabled.setter
    def is_write_forward_enabled(self, is_write_forward_enabled):
        """
        Sets the is_write_forward_enabled of this ReplicationConfig.
        (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.


        :param is_write_forward_enabled: The is_write_forward_enabled of this ReplicationConfig.
        :type: bool
        """
        self._is_write_forward_enabled = is_write_forward_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
