from eth_typing import (
    Address,
)

# EIP-7702 #
SET_CODE_TRANSACTION_TYPE = 4
MAGIC = b"\x05"
PER_AUTH_BASE_COST = 12_500
PER_EMPTY_ACCOUNT_BASE_COST = 25_000
DELEGATION_DESIGNATION_PREFIX = b"\xef\x01\x00"

# -- precompile addresses -- #
BLS12_G1ADD_PRECOMPILE_ADDRESS = b"\x0b"  # 0x0b
BLS12_G1MSM_PRECOMPILE_ADDRESS = b"\x0c"  # 0x0c
BLS12_G2ADD_PRECOMPILE_ADDRESS = b"\x0d"  # 0x0d
BLS12_G2MSM_PRECOMPILE_ADDRESS = b"\x0e"  # 0x0e
BLS12_PAIRING_CHECK_PRECOMPILE_ADDRESS = b"\x0f"  # 0x0f
BLS12_MAP_FP_TO_G1_PRECOMPILE_ADDRESS = b"\x10"  # 0x10
BLS12_MAP_FP2_TO_G2_PRECOMPILE_ADDRESS = b"\x11"  # 0x11

# EIP-7623 #
STANDARD_TOKEN_COST = 4
TOTAL_COST_FLOOR_PER_TOKEN = 10

# EIP-2935 #
HISTORY_SERVE_WINDOW = 8_191
HISTORY_STORAGE_ADDRESS = Address(
    b"\x00\x00\xf9\x08'\xf1\xc5:\x10\xcbz\x023[\x17S \x00)5"
)
HISTORY_STORAGE_CONTRACT_CODE = b"3s\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\x14`FW` 6\x03`BW_5`\x01C\x03\x81\x11`BWa\x1f\xff\x81C\x03\x11`BWa\x1f\xff\x90\x06T_R` _\xf3[__\xfd[_5a\x1f\xff`\x01C\x03\x06U\x00"  # noqa: E501

# EIP-7691 #
MAX_BLOB_GAS_PER_BLOCK = 1_179_648
TARGET_BLOB_GAS_PER_BLOCK = 786_432
BLOB_BASE_FEE_UPDATE_FRACTION_PRAGUE = 5_007_716

# EIP-6110 #
DEPOSIT_REQUEST_TYPE = b"\x00"
DEPOSIT_CONTRACT_ADDRESS = (
    b"\x00\x00\x00\x00!\x9a\xb5@5l\xbb\x83\x9c\xbe\x050=w\x05\xfa"  # noqa: E501
)
DEPOSIT_EVENT_SIGNATURE_HASH = b"d\x9b\xbcb\xd0\xe3\x13B\xaf\xeaN\\\xd8-@I\xe7\xe1\xee\x91/\xc0\x88\x9a\xa7\x90\x80;\xe3\x908\xc5"  # noqa: E501

# EIP-7002 #
WITHDRAWAL_REQUEST_PREDEPLOY_ADDRESS = Address(
    b"\x00\x00\ta\xefH\x0e\xb5^\x80\xd1\x9a\xd85y\xa6L\x00p\x02"
)
WITHDRAWAL_REQUEST_TYPE = b"\x01"
EXCESS_WITHDRAWAL_REQUESTS_STORAGE_SLOT = 0
WITHDRAWAL_REQUEST_COUNT_STORAGE_SLOT = 1
WITHDRAWAL_REQUEST_QUEUE_HEAD_STORAGE_SLOT = 2
WITHDRAWAL_REQUEST_QUEUE_TAIL_STORAGE_SLOT = 3
WITHDRAWAL_REQUEST_QUEUE_STORAGE_OFFSET = 4
MAX_WITHDRAWAL_REQUESTS_PER_BLOCK = 16
TARGET_WITHDRAWAL_REQUESTS_PER_BLOCK = 2
MIN_WITHDRAWAL_REQUEST_FEE = 1
WITHDRAWAL_REQUEST_FEE_UPDATE_FRACTION = 17
EXCESS_INHIBITOR = 2**256 - 1

# EIP-7251 #
CONSOLIDATION_REQUEST_TYPE = b"\x02"
CONSOLIDATION_REQUEST_PREDEPLOY_ADDRESS = Address(
    b"\x00\x00\xbb\xdd\xc7\xceH\x86B\xfbW\x9f\x8b\x00\xf3\xa5\x90\x00rQ"
)
