# The PEP 484 type hints stub file for the QtWebKitWidgets module.
#
# Generated by SIP 6.15.1
#
# Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtNetwork
from PyQt5 import QtGui
from PyQt5 import QtWidgets
from PyQt5 import QtPrintSupport
from PyQt5 import QtWebKit

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QGraphicsWebView(QtWidgets.QGraphicsWidget):

    def __init__(self, parent: QtWidgets.QGraphicsItem|None = ...) -> None: ...

    def setRenderHint(self, hint: QtGui.QPainter.RenderHint, enabled: bool = ...) -> None: ...
    def setRenderHints(self, hints: QtGui.QPainter.RenderHints) -> None: ...
    def renderHints(self) -> QtGui.QPainter.RenderHints: ...
    def setTiledBackingStoreFrozen(self, frozen: bool) -> None: ...
    def isTiledBackingStoreFrozen(self) -> bool: ...
    def setResizesToContents(self, enabled: bool) -> None: ...
    def resizesToContents(self) -> bool: ...
    def sceneEvent(self, a0: QtCore.QEvent|None) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent|None) -> None: ...
    def focusOutEvent(self, a0: QtGui.QFocusEvent|None) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent|None) -> None: ...
    def dropEvent(self, a0: QtWidgets.QGraphicsSceneDragDropEvent|None) -> None: ...
    def dragMoveEvent(self, a0: QtWidgets.QGraphicsSceneDragDropEvent|None) -> None: ...
    def dragLeaveEvent(self, a0: QtWidgets.QGraphicsSceneDragDropEvent|None) -> None: ...
    def dragEnterEvent(self, a0: QtWidgets.QGraphicsSceneDragDropEvent|None) -> None: ...
    def contextMenuEvent(self, a0: QtWidgets.QGraphicsSceneContextMenuEvent|None) -> None: ...
    def keyReleaseEvent(self, a0: QtGui.QKeyEvent|None) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent|None) -> None: ...
    def wheelEvent(self, a0: QtWidgets.QGraphicsSceneWheelEvent|None) -> None: ...
    def hoverLeaveEvent(self, a0: QtWidgets.QGraphicsSceneHoverEvent|None) -> None: ...
    def hoverMoveEvent(self, a0: QtWidgets.QGraphicsSceneHoverEvent|None) -> None: ...
    def mouseMoveEvent(self, a0: QtWidgets.QGraphicsSceneMouseEvent|None) -> None: ...
    def mouseReleaseEvent(self, a0: QtWidgets.QGraphicsSceneMouseEvent|None) -> None: ...
    def mouseDoubleClickEvent(self, a0: QtWidgets.QGraphicsSceneMouseEvent|None) -> None: ...
    def mousePressEvent(self, a0: QtWidgets.QGraphicsSceneMouseEvent|None) -> None: ...
    linkClicked: typing.ClassVar[QtCore.pyqtSignal]
    statusBarMessage: typing.ClassVar[QtCore.pyqtSignal]
    iconChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    urlChanged: typing.ClassVar[QtCore.pyqtSignal]
    loadProgress: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    loadStarted: typing.ClassVar[QtCore.pyqtSignal]
    def reload(self) -> None: ...
    def forward(self) -> None: ...
    def back(self) -> None: ...
    def stop(self) -> None: ...
    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def sizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF) -> QtCore.QSizeF: ...
    def event(self, a0: QtCore.QEvent|None) -> bool: ...
    def itemChange(self, change: QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def paint(self, painter: QtGui.QPainter|None, option: QtWidgets.QStyleOptionGraphicsItem|None, widget: QtWidgets.QWidget|None = ...) -> None: ...
    def updateGeometry(self) -> None: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def findText(self, subString: str|None, options: 'QWebPage.FindFlags' = ...) -> bool: ...
    def triggerPageAction(self, action: 'QWebPage.WebAction', checked: bool = ...) -> None: ...
    def pageAction(self, action: 'QWebPage.WebAction') -> QtWidgets.QAction|None: ...
    def settings(self) -> QtWebKit.QWebSettings|None: ...
    def history(self) -> QtWebKit.QWebHistory|None: ...
    def setContent(self, data: QtCore.QByteArray|bytes|bytearray, mimeType: str|None = ..., baseUrl: QtCore.QUrl = ...) -> None: ...
    def setHtml(self, html: str|None, baseUrl: QtCore.QUrl = ...) -> None: ...
    @typing.overload
    def load(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def load(self, request: QtNetwork.QNetworkRequest, operation: QtNetwork.QNetworkAccessManager.Operation = ..., body: QtCore.QByteArray|bytes|bytearray = ...) -> None: ...
    def isModified(self) -> bool: ...
    def setZoomFactor(self, a0: float) -> None: ...
    def zoomFactor(self) -> float: ...
    def icon(self) -> QtGui.QIcon: ...
    def title(self) -> str: ...
    def setUrl(self, a0: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def setPage(self, a0: 'QWebPage|None') -> None: ...
    def page(self) -> 'QWebPage|None': ...


class QWebHitTestResult(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebHitTestResult') -> None: ...

    def linkTitleString(self) -> str: ...
    def mediaUrl(self) -> QtCore.QUrl: ...
    def element(self) -> QtWebKit.QWebElement: ...
    def linkElement(self) -> QtWebKit.QWebElement: ...
    def enclosingBlockElement(self) -> QtWebKit.QWebElement: ...
    def boundingRect(self) -> QtCore.QRect: ...
    def frame(self) -> 'QWebFrame|None': ...
    def isContentSelected(self) -> bool: ...
    def isContentEditable(self) -> bool: ...
    def pixmap(self) -> QtGui.QPixmap: ...
    def imageUrl(self) -> QtCore.QUrl: ...
    def alternateText(self) -> str: ...
    def linkTargetFrame(self) -> 'QWebFrame|None': ...
    def linkTitle(self) -> QtCore.QUrl: ...
    def linkUrl(self) -> QtCore.QUrl: ...
    def linkText(self) -> str: ...
    def title(self) -> str: ...
    def pos(self) -> QtCore.QPoint: ...
    def isNull(self) -> bool: ...


class QWebFrame(QtCore.QObject):

    class RenderLayer(int):
        ContentsLayer = ... # type: QWebFrame.RenderLayer
        ScrollBarLayer = ... # type: QWebFrame.RenderLayer
        PanIconLayer = ... # type: QWebFrame.RenderLayer
        AllLayers = ... # type: QWebFrame.RenderLayer

    class ValueOwnership(int):
        QtOwnership = ... # type: QWebFrame.ValueOwnership
        ScriptOwnership = ... # type: QWebFrame.ValueOwnership
        AutoOwnership = ... # type: QWebFrame.ValueOwnership

    class RenderLayers(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: 'QWebFrame.RenderLayers'|'QWebFrame.RenderLayer') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __ixor__(self, f: 'QWebFrame.RenderLayers'|'QWebFrame.RenderLayer') -> 'QWebFrame.RenderLayers': ...
        def __xor__(self, f: 'QWebFrame.RenderLayers'|'QWebFrame.RenderLayer') -> 'QWebFrame.RenderLayers': ...
        def __ior__(self, f: 'QWebFrame.RenderLayers'|'QWebFrame.RenderLayer') -> 'QWebFrame.RenderLayers': ...
        def __or__(self, f: 'QWebFrame.RenderLayers'|'QWebFrame.RenderLayer') -> 'QWebFrame.RenderLayers': ...
        def __iand__(self, f: 'QWebFrame.RenderLayers'|'QWebFrame.RenderLayer') -> 'QWebFrame.RenderLayers': ...
        def __and__(self, f: 'QWebFrame.RenderLayers'|'QWebFrame.RenderLayer') -> 'QWebFrame.RenderLayers': ...
        def __invert__(self) -> 'QWebFrame.RenderLayers': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    def scrollToAnchor(self, anchor: str|None) -> None: ...
    pageChanged: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    loadStarted: typing.ClassVar[QtCore.pyqtSignal]
    contentsSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def findFirstElement(self, selectorQuery: str|None) -> QtWebKit.QWebElement: ...
    def findAllElements(self, selectorQuery: str|None) -> QtWebKit.QWebElementCollection: ...
    def documentElement(self) -> QtWebKit.QWebElement: ...
    def setFocus(self) -> None: ...
    def hasFocus(self) -> bool: ...
    @typing.overload
    def render(self, a0: QtGui.QPainter|None, clip: QtGui.QRegion = ...) -> None: ...
    @typing.overload
    def render(self, a0: QtGui.QPainter|None, layer: 'QWebFrame.RenderLayers', clip: QtGui.QRegion = ...) -> None: ...
    def scrollBarGeometry(self, orientation: QtCore.Qt.Orientation) -> QtCore.QRect: ...
    def baseUrl(self) -> QtCore.QUrl: ...
    def requestedUrl(self) -> QtCore.QUrl: ...
    def securityOrigin(self) -> QtWebKit.QWebSecurityOrigin: ...
    def setZoomFactor(self, factor: float) -> None: ...
    def zoomFactor(self) -> float: ...
    def setScrollPosition(self, pos: QtCore.QPoint) -> None: ...
    def scrollPosition(self) -> QtCore.QPoint: ...
    def scroll(self, a0: int, a1: int) -> None: ...
    def metaData(self) -> dict[str, list[str]]: ...
    iconChanged: typing.ClassVar[QtCore.pyqtSignal]
    initialLayoutCompleted: typing.ClassVar[QtCore.pyqtSignal]
    urlChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    javaScriptWindowObjectCleared: typing.ClassVar[QtCore.pyqtSignal]
    def print(self, printer: QtPrintSupport.QPrinter|None) -> None: ...
    def print_(self, printer: QtPrintSupport.QPrinter|None) -> None: ...
    def evaluateJavaScript(self, scriptSource: str|None) -> typing.Any: ...
    def event(self, a0: QtCore.QEvent|None) -> bool: ...
    def hitTestContent(self, pos: QtCore.QPoint) -> QWebHitTestResult: ...
    def contentsSize(self) -> QtCore.QSize: ...
    def geometry(self) -> QtCore.QRect: ...
    def pos(self) -> QtCore.QPoint: ...
    def scrollBarMaximum(self, orientation: QtCore.Qt.Orientation) -> int: ...
    def scrollBarMinimum(self, orientation: QtCore.Qt.Orientation) -> int: ...
    def scrollBarValue(self, orientation: QtCore.Qt.Orientation) -> int: ...
    def setScrollBarValue(self, orientation: QtCore.Qt.Orientation, value: int) -> None: ...
    def setScrollBarPolicy(self, orientation: QtCore.Qt.Orientation, policy: QtCore.Qt.ScrollBarPolicy) -> None: ...
    def scrollBarPolicy(self, orientation: QtCore.Qt.Orientation) -> QtCore.Qt.ScrollBarPolicy: ...
    def childFrames(self) -> list['QWebFrame']: ...
    def parentFrame(self) -> 'QWebFrame|None': ...
    def frameName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def url(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def title(self) -> str: ...
    def toPlainText(self) -> str: ...
    def toHtml(self) -> str: ...
    def addToJavaScriptWindowObject(self, name: str|None, object: QtCore.QObject|None, ownership: 'QWebFrame.ValueOwnership' = ...) -> None: ...
    def setContent(self, data: QtCore.QByteArray|bytes|bytearray, mimeType: str|None = ..., baseUrl: QtCore.QUrl = ...) -> None: ...
    def setHtml(self, html: str|None, baseUrl: QtCore.QUrl = ...) -> None: ...
    @typing.overload
    def load(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def load(self, request: QtNetwork.QNetworkRequest, operation: QtNetwork.QNetworkAccessManager.Operation = ..., body: QtCore.QByteArray|bytes|bytearray = ...) -> None: ...
    def page(self) -> 'QWebPage|None': ...


class QWebInspector(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def closeEvent(self, event: QtGui.QCloseEvent|None) -> None: ...
    def hideEvent(self, event: QtGui.QHideEvent|None) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent|None) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent|None) -> None: ...
    def event(self, a0: QtCore.QEvent|None) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def page(self) -> 'QWebPage|None': ...
    def setPage(self, page: 'QWebPage|None') -> None: ...


class QWebPage(QtCore.QObject):

    class VisibilityState(int):
        VisibilityStateVisible = ... # type: QWebPage.VisibilityState
        VisibilityStateHidden = ... # type: QWebPage.VisibilityState
        VisibilityStatePrerender = ... # type: QWebPage.VisibilityState
        VisibilityStateUnloaded = ... # type: QWebPage.VisibilityState

    class Feature(int):
        Notifications = ... # type: QWebPage.Feature
        Geolocation = ... # type: QWebPage.Feature

    class PermissionPolicy(int):
        PermissionUnknown = ... # type: QWebPage.PermissionPolicy
        PermissionGrantedByUser = ... # type: QWebPage.PermissionPolicy
        PermissionDeniedByUser = ... # type: QWebPage.PermissionPolicy

    class ErrorDomain(int):
        QtNetwork = ... # type: QWebPage.ErrorDomain
        Http = ... # type: QWebPage.ErrorDomain
        WebKit = ... # type: QWebPage.ErrorDomain

    class Extension(int):
        ChooseMultipleFilesExtension = ... # type: QWebPage.Extension
        ErrorPageExtension = ... # type: QWebPage.Extension

    class WebWindowType(int):
        WebBrowserWindow = ... # type: QWebPage.WebWindowType
        WebModalDialog = ... # type: QWebPage.WebWindowType

    class LinkDelegationPolicy(int):
        DontDelegateLinks = ... # type: QWebPage.LinkDelegationPolicy
        DelegateExternalLinks = ... # type: QWebPage.LinkDelegationPolicy
        DelegateAllLinks = ... # type: QWebPage.LinkDelegationPolicy

    class FindFlag(int):
        FindBackward = ... # type: QWebPage.FindFlag
        FindCaseSensitively = ... # type: QWebPage.FindFlag
        FindWrapsAroundDocument = ... # type: QWebPage.FindFlag
        HighlightAllOccurrences = ... # type: QWebPage.FindFlag
        FindAtWordBeginningsOnly = ... # type: QWebPage.FindFlag
        TreatMedialCapitalAsWordBeginning = ... # type: QWebPage.FindFlag
        FindBeginsInSelection = ... # type: QWebPage.FindFlag

    class WebAction(int):
        NoWebAction = ... # type: QWebPage.WebAction
        OpenLink = ... # type: QWebPage.WebAction
        OpenLinkInNewWindow = ... # type: QWebPage.WebAction
        OpenFrameInNewWindow = ... # type: QWebPage.WebAction
        DownloadLinkToDisk = ... # type: QWebPage.WebAction
        CopyLinkToClipboard = ... # type: QWebPage.WebAction
        OpenImageInNewWindow = ... # type: QWebPage.WebAction
        DownloadImageToDisk = ... # type: QWebPage.WebAction
        CopyImageToClipboard = ... # type: QWebPage.WebAction
        Back = ... # type: QWebPage.WebAction
        Forward = ... # type: QWebPage.WebAction
        Stop = ... # type: QWebPage.WebAction
        Reload = ... # type: QWebPage.WebAction
        Cut = ... # type: QWebPage.WebAction
        Copy = ... # type: QWebPage.WebAction
        Paste = ... # type: QWebPage.WebAction
        Undo = ... # type: QWebPage.WebAction
        Redo = ... # type: QWebPage.WebAction
        MoveToNextChar = ... # type: QWebPage.WebAction
        MoveToPreviousChar = ... # type: QWebPage.WebAction
        MoveToNextWord = ... # type: QWebPage.WebAction
        MoveToPreviousWord = ... # type: QWebPage.WebAction
        MoveToNextLine = ... # type: QWebPage.WebAction
        MoveToPreviousLine = ... # type: QWebPage.WebAction
        MoveToStartOfLine = ... # type: QWebPage.WebAction
        MoveToEndOfLine = ... # type: QWebPage.WebAction
        MoveToStartOfBlock = ... # type: QWebPage.WebAction
        MoveToEndOfBlock = ... # type: QWebPage.WebAction
        MoveToStartOfDocument = ... # type: QWebPage.WebAction
        MoveToEndOfDocument = ... # type: QWebPage.WebAction
        SelectNextChar = ... # type: QWebPage.WebAction
        SelectPreviousChar = ... # type: QWebPage.WebAction
        SelectNextWord = ... # type: QWebPage.WebAction
        SelectPreviousWord = ... # type: QWebPage.WebAction
        SelectNextLine = ... # type: QWebPage.WebAction
        SelectPreviousLine = ... # type: QWebPage.WebAction
        SelectStartOfLine = ... # type: QWebPage.WebAction
        SelectEndOfLine = ... # type: QWebPage.WebAction
        SelectStartOfBlock = ... # type: QWebPage.WebAction
        SelectEndOfBlock = ... # type: QWebPage.WebAction
        SelectStartOfDocument = ... # type: QWebPage.WebAction
        SelectEndOfDocument = ... # type: QWebPage.WebAction
        DeleteStartOfWord = ... # type: QWebPage.WebAction
        DeleteEndOfWord = ... # type: QWebPage.WebAction
        SetTextDirectionDefault = ... # type: QWebPage.WebAction
        SetTextDirectionLeftToRight = ... # type: QWebPage.WebAction
        SetTextDirectionRightToLeft = ... # type: QWebPage.WebAction
        ToggleBold = ... # type: QWebPage.WebAction
        ToggleItalic = ... # type: QWebPage.WebAction
        ToggleUnderline = ... # type: QWebPage.WebAction
        InspectElement = ... # type: QWebPage.WebAction
        InsertParagraphSeparator = ... # type: QWebPage.WebAction
        InsertLineSeparator = ... # type: QWebPage.WebAction
        SelectAll = ... # type: QWebPage.WebAction
        ReloadAndBypassCache = ... # type: QWebPage.WebAction
        PasteAndMatchStyle = ... # type: QWebPage.WebAction
        RemoveFormat = ... # type: QWebPage.WebAction
        ToggleStrikethrough = ... # type: QWebPage.WebAction
        ToggleSubscript = ... # type: QWebPage.WebAction
        ToggleSuperscript = ... # type: QWebPage.WebAction
        InsertUnorderedList = ... # type: QWebPage.WebAction
        InsertOrderedList = ... # type: QWebPage.WebAction
        Indent = ... # type: QWebPage.WebAction
        Outdent = ... # type: QWebPage.WebAction
        AlignCenter = ... # type: QWebPage.WebAction
        AlignJustified = ... # type: QWebPage.WebAction
        AlignLeft = ... # type: QWebPage.WebAction
        AlignRight = ... # type: QWebPage.WebAction
        StopScheduledPageRefresh = ... # type: QWebPage.WebAction
        CopyImageUrlToClipboard = ... # type: QWebPage.WebAction
        OpenLinkInThisWindow = ... # type: QWebPage.WebAction
        DownloadMediaToDisk = ... # type: QWebPage.WebAction
        CopyMediaUrlToClipboard = ... # type: QWebPage.WebAction
        ToggleMediaControls = ... # type: QWebPage.WebAction
        ToggleMediaLoop = ... # type: QWebPage.WebAction
        ToggleMediaPlayPause = ... # type: QWebPage.WebAction
        ToggleMediaMute = ... # type: QWebPage.WebAction
        ToggleVideoFullscreen = ... # type: QWebPage.WebAction

    class NavigationType(int):
        NavigationTypeLinkClicked = ... # type: QWebPage.NavigationType
        NavigationTypeFormSubmitted = ... # type: QWebPage.NavigationType
        NavigationTypeBackOrForward = ... # type: QWebPage.NavigationType
        NavigationTypeReload = ... # type: QWebPage.NavigationType
        NavigationTypeFormResubmitted = ... # type: QWebPage.NavigationType
        NavigationTypeOther = ... # type: QWebPage.NavigationType

    class FindFlags(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: 'QWebPage.FindFlags'|'QWebPage.FindFlag') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __ixor__(self, f: 'QWebPage.FindFlags'|'QWebPage.FindFlag') -> 'QWebPage.FindFlags': ...
        def __xor__(self, f: 'QWebPage.FindFlags'|'QWebPage.FindFlag') -> 'QWebPage.FindFlags': ...
        def __ior__(self, f: 'QWebPage.FindFlags'|'QWebPage.FindFlag') -> 'QWebPage.FindFlags': ...
        def __or__(self, f: 'QWebPage.FindFlags'|'QWebPage.FindFlag') -> 'QWebPage.FindFlags': ...
        def __iand__(self, f: 'QWebPage.FindFlags'|'QWebPage.FindFlag') -> 'QWebPage.FindFlags': ...
        def __and__(self, f: 'QWebPage.FindFlags'|'QWebPage.FindFlag') -> 'QWebPage.FindFlags': ...
        def __invert__(self) -> 'QWebPage.FindFlags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class ExtensionOption(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPage.ExtensionOption') -> None: ...

    class ExtensionReturn(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPage.ExtensionReturn') -> None: ...

    class ChooseMultipleFilesExtensionOption('QWebPage.ExtensionOption'):

        parentFrame = ... # type: QWebFrame
        suggestedFileNames = ... # type: collections.abc.Iterable[str|None]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPage.ChooseMultipleFilesExtensionOption') -> None: ...

    class ChooseMultipleFilesExtensionReturn('QWebPage.ExtensionReturn'):

        fileNames = ... # type: collections.abc.Iterable[str|None]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPage.ChooseMultipleFilesExtensionReturn') -> None: ...

    class ErrorPageExtensionOption('QWebPage.ExtensionOption'):

        domain = ... # type: 'QWebPage.ErrorDomain'
        error = ... # type: int
        errorString = ... # type: str|None
        frame = ... # type: QWebFrame
        url = ... # type: QtCore.QUrl

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPage.ErrorPageExtensionOption') -> None: ...

    class ErrorPageExtensionReturn('QWebPage.ExtensionReturn'):

        baseUrl = ... # type: QtCore.QUrl
        content = ... # type: QtCore.QByteArray|bytes|bytearray
        contentType = ... # type: str|None
        encoding = ... # type: str|None

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPage.ErrorPageExtensionReturn') -> None: ...

    class ViewportAttributes(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other: 'QWebPage.ViewportAttributes') -> None: ...

        def size(self) -> QtCore.QSizeF: ...
        def isValid(self) -> bool: ...
        def isUserScalable(self) -> bool: ...
        def devicePixelRatio(self) -> float: ...
        def maximumScaleFactor(self) -> float: ...
        def minimumScaleFactor(self) -> float: ...
        def initialScaleFactor(self) -> float: ...

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def setVisibilityState(self, a0: 'QWebPage.VisibilityState') -> None: ...
    def visibilityState(self) -> 'QWebPage.VisibilityState': ...
    featurePermissionRequestCanceled: typing.ClassVar[QtCore.pyqtSignal]
    featurePermissionRequested: typing.ClassVar[QtCore.pyqtSignal]
    viewportChangeRequested: typing.ClassVar[QtCore.pyqtSignal]
    applicationCacheQuotaExceeded: typing.ClassVar[QtCore.pyqtSignal]
    def supportsContentType(self, mimeType: str|None) -> bool: ...
    def supportedContentTypes(self) -> list[str]: ...
    def setFeaturePermission(self, frame: QWebFrame|None, feature: 'QWebPage.Feature', policy: 'QWebPage.PermissionPolicy') -> None: ...
    def setActualVisibleContentRect(self, rect: QtCore.QRect) -> None: ...
    def viewportAttributesForSize(self, availableSize: QtCore.QSize) -> 'QWebPage.ViewportAttributes': ...
    def selectedHtml(self) -> str: ...
    def hasSelection(self) -> bool: ...
    def shouldInterruptJavaScript(self) -> bool: ...
    def setPreferredContentsSize(self, size: QtCore.QSize) -> None: ...
    def preferredContentsSize(self) -> QtCore.QSize: ...
    def frameAt(self, pos: QtCore.QPoint) -> QWebFrame|None: ...
    restoreFrameStateRequested: typing.ClassVar[QtCore.pyqtSignal]
    saveFrameStateRequested: typing.ClassVar[QtCore.pyqtSignal]
    databaseQuotaExceeded: typing.ClassVar[QtCore.pyqtSignal]
    contentsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def createStandardContextMenu(self) -> QtWidgets.QMenu|None: ...
    def isContentEditable(self) -> bool: ...
    def setContentEditable(self, editable: bool) -> None: ...
    def userAgentForUrl(self, url: QtCore.QUrl) -> str: ...
    def javaScriptConsoleMessage(self, message: str|None, lineNumber: int, sourceID: str|None) -> None: ...
    def javaScriptPrompt(self, originatingFrame: QWebFrame|None, msg: str|None, defaultValue: str|None) -> typing.Tuple[bool, str]: ...
    def javaScriptConfirm(self, originatingFrame: QWebFrame|None, msg: str|None) -> bool: ...
    def javaScriptAlert(self, originatingFrame: QWebFrame|None, msg: str|None) -> None: ...
    def chooseFile(self, originatingFrame: QWebFrame|None, oldFile: str|None) -> str: ...
    def acceptNavigationRequest(self, frame: QWebFrame|None, request: QtNetwork.QNetworkRequest, type: 'QWebPage.NavigationType') -> bool: ...
    def createPlugin(self, classid: str|None, url: QtCore.QUrl, paramNames: collections.abc.Iterable[str|None], paramValues: collections.abc.Iterable[str|None]) -> QtCore.QObject|None: ...
    def createWindow(self, type: 'QWebPage.WebWindowType') -> 'QWebPage|None': ...
    microFocusChanged: typing.ClassVar[QtCore.pyqtSignal]
    downloadRequested: typing.ClassVar[QtCore.pyqtSignal]
    unsupportedContent: typing.ClassVar[QtCore.pyqtSignal]
    menuBarVisibilityChangeRequested: typing.ClassVar[QtCore.pyqtSignal]
    statusBarVisibilityChangeRequested: typing.ClassVar[QtCore.pyqtSignal]
    toolBarVisibilityChangeRequested: typing.ClassVar[QtCore.pyqtSignal]
    linkClicked: typing.ClassVar[QtCore.pyqtSignal]
    printRequested: typing.ClassVar[QtCore.pyqtSignal]
    windowCloseRequested: typing.ClassVar[QtCore.pyqtSignal]
    scrollRequested: typing.ClassVar[QtCore.pyqtSignal]
    repaintRequested: typing.ClassVar[QtCore.pyqtSignal]
    geometryChangeRequested: typing.ClassVar[QtCore.pyqtSignal]
    frameCreated: typing.ClassVar[QtCore.pyqtSignal]
    selectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    statusBarMessage: typing.ClassVar[QtCore.pyqtSignal]
    linkHovered: typing.ClassVar[QtCore.pyqtSignal]
    loadStarted: typing.ClassVar[QtCore.pyqtSignal]
    loadProgress: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    def supportsExtension(self, extension: 'QWebPage.Extension') -> bool: ...
    def extension(self, extension: 'QWebPage.Extension', option: 'QWebPage.ExtensionOption|None' = ..., output: 'QWebPage.ExtensionReturn|None' = ...) -> bool: ...
    def updatePositionDependentActions(self, pos: QtCore.QPoint) -> None: ...
    def swallowContextMenuEvent(self, event: QtGui.QContextMenuEvent|None) -> bool: ...
    def palette(self) -> QtGui.QPalette: ...
    def setPalette(self, palette: QtGui.QPalette) -> None: ...
    def linkDelegationPolicy(self) -> 'QWebPage.LinkDelegationPolicy': ...
    def setLinkDelegationPolicy(self, policy: 'QWebPage.LinkDelegationPolicy') -> None: ...
    def forwardUnsupportedContent(self) -> bool: ...
    def setForwardUnsupportedContent(self, forward: bool) -> None: ...
    def findText(self, subString: str|None, options: 'QWebPage.FindFlags' = ...) -> bool: ...
    def inputMethodQuery(self, property: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def event(self, a0: QtCore.QEvent|None) -> bool: ...
    def setViewportSize(self, size: QtCore.QSize) -> None: ...
    def viewportSize(self) -> QtCore.QSize: ...
    def triggerAction(self, action: 'QWebPage.WebAction', checked: bool = ...) -> None: ...
    def action(self, action: 'QWebPage.WebAction') -> QtWidgets.QAction|None: ...
    def selectedText(self) -> str: ...
    def bytesReceived(self) -> int: ...
    def totalBytes(self) -> int: ...
    def pluginFactory(self) -> QtWebKit.QWebPluginFactory|None: ...
    def setPluginFactory(self, factory: QtWebKit.QWebPluginFactory|None) -> None: ...
    def networkAccessManager(self) -> QtNetwork.QNetworkAccessManager|None: ...
    def setNetworkAccessManager(self, manager: QtNetwork.QNetworkAccessManager|None) -> None: ...
    def undoStack(self) -> QtWidgets.QUndoStack|None: ...
    def isModified(self) -> bool: ...
    def view(self) -> QtWidgets.QWidget|None: ...
    def setView(self, view: QtWidgets.QWidget|None) -> None: ...
    def settings(self) -> QtWebKit.QWebSettings|None: ...
    def history(self) -> QtWebKit.QWebHistory|None: ...
    def currentFrame(self) -> QWebFrame|None: ...
    def mainFrame(self) -> QWebFrame|None: ...


class QWebView(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def selectedHtml(self) -> str: ...
    def hasSelection(self) -> bool: ...
    def setRenderHint(self, hint: QtGui.QPainter.RenderHint, enabled: bool = ...) -> None: ...
    def setRenderHints(self, hints: QtGui.QPainter.RenderHints) -> None: ...
    def renderHints(self) -> QtGui.QPainter.RenderHints: ...
    def setZoomFactor(self, factor: float) -> None: ...
    def zoomFactor(self) -> float: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent|None) -> None: ...
    def focusOutEvent(self, a0: QtGui.QFocusEvent|None) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent|None) -> None: ...
    def dropEvent(self, a0: QtGui.QDropEvent|None) -> None: ...
    def dragMoveEvent(self, a0: QtGui.QDragMoveEvent|None) -> None: ...
    def dragLeaveEvent(self, a0: QtGui.QDragLeaveEvent|None) -> None: ...
    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent|None) -> None: ...
    def keyReleaseEvent(self, a0: QtGui.QKeyEvent|None) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent|None) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent|None) -> None: ...
    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent|None) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent|None) -> None: ...
    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent|None) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent|None) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent|None) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent|None) -> None: ...
    def paintEvent(self, ev: QtGui.QPaintEvent|None) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent|None) -> None: ...
    def createWindow(self, type: QWebPage.WebWindowType) -> 'QWebView|None': ...
    urlChanged: typing.ClassVar[QtCore.pyqtSignal]
    iconChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    linkClicked: typing.ClassVar[QtCore.pyqtSignal]
    statusBarMessage: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    loadProgress: typing.ClassVar[QtCore.pyqtSignal]
    loadStarted: typing.ClassVar[QtCore.pyqtSignal]
    def print(self, printer: QtPrintSupport.QPrinter|None) -> None: ...
    def print_(self, printer: QtPrintSupport.QPrinter|None) -> None: ...
    def reload(self) -> None: ...
    def forward(self) -> None: ...
    def back(self) -> None: ...
    def stop(self) -> None: ...
    def event(self, a0: QtCore.QEvent|None) -> bool: ...
    def findText(self, subString: str|None, options: QWebPage.FindFlags = ...) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def inputMethodQuery(self, property: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isModified(self) -> bool: ...
    def triggerPageAction(self, action: QWebPage.WebAction, checked: bool = ...) -> None: ...
    def pageAction(self, action: QWebPage.WebAction) -> QtWidgets.QAction|None: ...
    def selectedText(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def url(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def title(self) -> str: ...
    def settings(self) -> QtWebKit.QWebSettings|None: ...
    def history(self) -> QtWebKit.QWebHistory|None: ...
    def setContent(self, data: QtCore.QByteArray|bytes|bytearray, mimeType: str|None = ..., baseUrl: QtCore.QUrl = ...) -> None: ...
    def setHtml(self, html: str|None, baseUrl: QtCore.QUrl = ...) -> None: ...
    @typing.overload
    def load(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def load(self, request: QtNetwork.QNetworkRequest, operation: QtNetwork.QNetworkAccessManager.Operation = ..., body: QtCore.QByteArray|bytes|bytearray = ...) -> None: ...
    def setPage(self, page: QWebPage|None) -> None: ...
    def page(self) -> QWebPage|None: ...
